/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cache;

import java.io.Closeable;
import java.io.InputStream;
import net.sf.ehcache.CacheManager;
import org.apache.camel.component.cache.CacheManagerFactory;
import org.apache.camel.component.cache.EHCacheUtil;
import org.apache.camel.util.IOHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCacheManagerFactory
extends CacheManagerFactory {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultCacheManagerFactory.class);
    private InputStream is;
    private String configurationFile;

    public DefaultCacheManagerFactory() {
        this(null, null);
    }

    public DefaultCacheManagerFactory(InputStream is, String configurationFile) {
        this.is = is;
        this.configurationFile = configurationFile;
    }

    @Override
    protected CacheManager createCacheManagerInstance() {
        if (this.is == null) {
            LOG.info("Creating CacheManager using Ehcache defaults");
            return EHCacheUtil.createCacheManager();
        }
        LOG.info("Creating CacheManager using camel-cache configuration: {}", (Object)this.configurationFile);
        return EHCacheUtil.createCacheManager(this.is);
    }

    @Override
    protected void doStop() throws Exception {
        if (this.is != null) {
            IOHelper.close((Closeable)this.is);
        }
        super.doStop();
    }
}

