/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hawtdb;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.impl.DefaultExchange;
import org.apache.camel.impl.DefaultExchangeHolder;
import org.fusesource.hawtbuf.Buffer;
import org.fusesource.hawtbuf.DataByteArrayInputStream;
import org.fusesource.hawtbuf.DataByteArrayOutputStream;
import org.fusesource.hawtbuf.codec.Codec;
import org.fusesource.hawtbuf.codec.ObjectCodec;
import org.fusesource.hawtbuf.codec.StringCodec;

public final class HawtDBCamelCodec {
    private Codec<String> keyCodec = new StringCodec();
    private Codec<DefaultExchangeHolder> exchangeCodec = new ObjectCodec();

    public Buffer marshallKey(String key) throws IOException {
        DataByteArrayOutputStream baos = new DataByteArrayOutputStream();
        this.keyCodec.encode((Object)key, (DataOutput)baos);
        return baos.toBuffer();
    }

    public String unmarshallKey(Buffer buffer) throws IOException {
        DataByteArrayInputStream bais = new DataByteArrayInputStream(buffer);
        String key = (String)this.keyCodec.decode((DataInput)bais);
        return key;
    }

    public Buffer marshallExchange(CamelContext camelContext, Exchange exchange) throws IOException {
        DataByteArrayOutputStream baos = new DataByteArrayOutputStream();
        DefaultExchangeHolder pe = DefaultExchangeHolder.marshal((Exchange)exchange, (boolean)false);
        DefaultExchangeHolder.addProperty((DefaultExchangeHolder)pe, (String)"CamelAggregatedSize", (Serializable)((Serializable)exchange.getProperty("CamelAggregatedSize", Integer.class)));
        DefaultExchangeHolder.addProperty((DefaultExchangeHolder)pe, (String)"CamelAggregatedTimeout", (Serializable)((Serializable)exchange.getProperty("CamelAggregatedTimeout", Long.class)));
        DefaultExchangeHolder.addProperty((DefaultExchangeHolder)pe, (String)"CamelAggregatedCompletedBy", (Serializable)((Serializable)exchange.getProperty("CamelAggregatedCompletedBy", String.class)));
        DefaultExchangeHolder.addProperty((DefaultExchangeHolder)pe, (String)"CamelAggregatedCorrelationKey", (Serializable)((Serializable)exchange.getProperty("CamelAggregatedCorrelationKey", String.class)));
        DefaultExchangeHolder.addProperty((DefaultExchangeHolder)pe, (String)"CamelAggregatedCollectionGuard", (Serializable)((Serializable)exchange.getProperty("CamelAggregatedCollectionGuard", String.class)));
        if (exchange.getFromEndpoint() != null) {
            DefaultExchangeHolder.addProperty((DefaultExchangeHolder)pe, (String)"CamelAggregatedFromEndpoint", (Serializable)((Object)exchange.getFromEndpoint().getEndpointUri()));
        }
        this.exchangeCodec.encode((Object)pe, (DataOutput)baos);
        return baos.toBuffer();
    }

    public Exchange unmarshallExchange(CamelContext camelContext, Buffer buffer) throws IOException {
        Endpoint fromEndpoint;
        DataByteArrayInputStream bais = new DataByteArrayInputStream(buffer);
        DefaultExchangeHolder pe = (DefaultExchangeHolder)this.exchangeCodec.decode((DataInput)bais);
        DefaultExchange answer = new DefaultExchange(camelContext);
        DefaultExchangeHolder.unmarshal((Exchange)answer, (DefaultExchangeHolder)pe);
        String fromEndpointUri = (String)answer.removeProperty("CamelAggregatedFromEndpoint");
        if (fromEndpointUri != null && (fromEndpoint = camelContext.hasEndpoint(fromEndpointUri)) != null) {
            answer.setFromEndpoint(fromEndpoint);
        }
        return answer;
    }
}

