/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hdfs2;

import java.net.URI;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HdfsOsgiHelper {
    private static final Logger LOG = LoggerFactory.getLogger(HdfsOsgiHelper.class);

    public HdfsOsgiHelper(Map<String, String> fileSystems) {
        try {
            ClassLoader cl = this.getClass().getClassLoader();
            Configuration conf = new Configuration();
            for (String key : fileSystems.keySet()) {
                URI uri = URI.create(key);
                conf.setClass(String.format("fs.%s.impl", uri.getScheme()), cl.loadClass(fileSystems.get(key)), FileSystem.class);
                FileSystem.get((URI)uri, (Configuration)conf);
            }
        }
        catch (Exception e) {
            LOG.debug(e.getMessage());
        }
    }
}

