/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.git.producer;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.git.GitEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ListBranchCommand;
import org.eclipse.jgit.api.PullCommand;
import org.eclipse.jgit.api.PullResult;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(GitProducer.class);
    private final GitEndpoint endpoint;
    private Repository repo;
    private Git git;

    public GitProducer(GitEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.repo = this.getLocalRepository();
        this.git = new Git(this.repo);
    }

    protected void doStop() throws Exception {
        super.doStop();
        this.repo.close();
        this.git.close();
    }

    public void process(Exchange exchange) throws Exception {
        String operation = ObjectHelper.isEmpty((Object)this.endpoint.getOperation()) ? (String)exchange.getIn().getHeader("CamelGitOperation", String.class) : this.endpoint.getOperation();
        if (ObjectHelper.isEmpty((Object)this.endpoint.getLocalPath())) {
            throw new IllegalArgumentException("Local path must specified to execute " + operation);
        }
        switch (operation) {
            case "clone": {
                this.doClone(exchange, operation);
                break;
            }
            case "init": {
                this.doInit(exchange, operation);
                break;
            }
            case "add": {
                this.doAdd(exchange, operation);
                break;
            }
            case "remove": {
                this.doRemove(exchange, operation);
                break;
            }
            case "commit": {
                this.doCommit(exchange, operation);
                break;
            }
            case "commitAll": {
                this.doCommitAll(exchange, operation);
                break;
            }
            case "createBranch": {
                this.doCreateBranch(exchange, operation);
                break;
            }
            case "deleteBranch": {
                this.doDeleteBranch(exchange, operation);
                break;
            }
            case "status": {
                this.doStatus(exchange, operation);
                break;
            }
            case "log": {
                this.doLog(exchange, operation);
                break;
            }
            case "push": {
                this.doPush(exchange, operation);
                break;
            }
            case "pull": {
                this.doPull(exchange, operation);
                break;
            }
            case "createTag": {
                this.doCreateTag(exchange, operation);
                break;
            }
            case "deleteTag": {
                this.doDeleteTag(exchange, operation);
                break;
            }
            case "showBranches": {
                this.doShowBranches(exchange, operation);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation " + operation);
            }
        }
    }

    protected void doClone(Exchange exchange, String operation) throws Exception {
        block10: {
            Git result = null;
            if (ObjectHelper.isEmpty((Object)this.endpoint.getLocalPath())) {
                throw new IllegalArgumentException("Local path must specified to execute " + operation);
            }
            try {
                File localRepo = new File(this.endpoint.getLocalPath(), "");
                if (!localRepo.exists()) {
                    if (ObjectHelper.isNotEmpty((Object)this.endpoint.getUsername()) && ObjectHelper.isNotEmpty((Object)this.endpoint.getPassword())) {
                        UsernamePasswordCredentialsProvider credentials = new UsernamePasswordCredentialsProvider(this.endpoint.getUsername(), this.endpoint.getPassword());
                        GitProducer gitProducer = this;
                        result = ((CloneCommand)gitProducer.git.cloneRepository().setCredentialsProvider((CredentialsProvider)credentials)).setURI(this.endpoint.getRemotePath()).setDirectory(new File(this.endpoint.getLocalPath(), "")).call();
                    } else {
                        GitProducer gitProducer = this;
                        result = gitProducer.git.cloneRepository().setURI(this.endpoint.getRemotePath()).setDirectory(new File(this.endpoint.getLocalPath(), "")).call();
                    }
                    break block10;
                }
                throw new IllegalArgumentException("The local repository directory already exists");
            }
            catch (Exception e) {
                LOG.error("There was an error in Git " + operation + " operation");
                throw e;
            }
            finally {
                if (ObjectHelper.isNotEmpty(result)) {
                    result.close();
                }
            }
        }
    }

    protected void doInit(Exchange exchange, String operation) throws Exception {
        Git result = null;
        if (ObjectHelper.isEmpty((Object)this.endpoint.getLocalPath())) {
            throw new IllegalArgumentException("Local path must specified to execute " + operation);
        }
        try {
            GitProducer gitProducer = this;
            result = gitProducer.git.init().setDirectory(new File(this.endpoint.getLocalPath(), "")).setBare(false).call();
        }
        catch (Exception e) {
            LOG.error("There was an error in Git " + operation + " operation");
            throw e;
        }
        finally {
            if (ObjectHelper.isNotEmpty(result)) {
                result.close();
            }
        }
    }

    protected void doAdd(Exchange exchange, String operation) throws Exception {
        String fileName = null;
        if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelGitFilename"))) {
            throw new IllegalArgumentException("File name must be specified to execute " + operation);
        }
        fileName = (String)exchange.getIn().getHeader("CamelGitFilename", String.class);
        try {
            if (ObjectHelper.isNotEmpty((Object)this.endpoint.getBranchName())) {
                this.git.checkout().setCreateBranch(false).setName(this.endpoint.getBranchName()).call();
            }
            this.git.add().addFilepattern(fileName).call();
        }
        catch (Exception e) {
            LOG.error("There was an error in Git " + operation + " operation");
            throw e;
        }
    }

    protected void doRemove(Exchange exchange, String operation) throws Exception {
        String fileName = null;
        if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelGitFilename"))) {
            throw new IllegalArgumentException("File name must be specified to execute " + operation);
        }
        fileName = (String)exchange.getIn().getHeader("CamelGitFilename", String.class);
        try {
            if (ObjectHelper.isNotEmpty((Object)this.endpoint.getBranchName())) {
                this.git.checkout().setCreateBranch(false).setName(this.endpoint.getBranchName()).call();
            }
            this.git.rm().addFilepattern(fileName).call();
        }
        catch (Exception e) {
            LOG.error("There was an error in Git " + operation + " operation");
            throw e;
        }
    }

    protected void doCommit(Exchange exchange, String operation) throws Exception {
        String commitMessage = null;
        if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelGitCommitMessage"))) {
            throw new IllegalArgumentException("Commit message must be specified to execute " + operation);
        }
        commitMessage = (String)exchange.getIn().getHeader("CamelGitCommitMessage", String.class);
        try {
            if (ObjectHelper.isNotEmpty((Object)this.endpoint.getBranchName())) {
                this.git.checkout().setCreateBranch(false).setName(this.endpoint.getBranchName()).call();
            }
            this.git.commit().setMessage(commitMessage).call();
        }
        catch (Exception e) {
            LOG.error("There was an error in Git " + operation + " operation");
            throw e;
        }
    }

    protected void doCommitAll(Exchange exchange, String operation) throws Exception {
        String commitMessage = null;
        if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelGitCommitMessage"))) {
            throw new IllegalArgumentException("Commit message must be specified to execute " + operation);
        }
        commitMessage = (String)exchange.getIn().getHeader("CamelGitCommitMessage", String.class);
        try {
            if (ObjectHelper.isNotEmpty((Object)this.endpoint.getBranchName())) {
                this.git.checkout().setCreateBranch(false).setName(this.endpoint.getBranchName()).call();
            }
            this.git.commit().setAll(true).setMessage(commitMessage).call();
        }
        catch (Exception e) {
            LOG.error("There was an error in Git " + operation + " operation");
            throw e;
        }
    }

    protected void doCreateBranch(Exchange exchange, String operation) throws Exception {
        if (ObjectHelper.isEmpty((Object)this.endpoint.getBranchName())) {
            throw new IllegalArgumentException("Branch Name must be specified to execute " + operation);
        }
        try {
            this.git.branchCreate().setName(this.endpoint.getBranchName()).call();
        }
        catch (Exception e) {
            LOG.error("There was an error in Git " + operation + " operation");
            throw e;
        }
    }

    protected void doDeleteBranch(Exchange exchange, String operation) throws Exception {
        if (ObjectHelper.isEmpty((Object)this.endpoint.getBranchName())) {
            throw new IllegalArgumentException("Branch Name must be specified to execute " + operation);
        }
        try {
            this.git.branchDelete().setBranchNames(new String[]{this.endpoint.getBranchName()}).call();
        }
        catch (Exception e) {
            LOG.error("There was an error in Git " + operation + " operation");
            throw e;
        }
    }

    protected void doStatus(Exchange exchange, String operation) throws Exception {
        Status status = null;
        try {
            if (ObjectHelper.isNotEmpty((Object)this.endpoint.getBranchName())) {
                this.git.checkout().setCreateBranch(false).setName(this.endpoint.getBranchName()).call();
            }
            status = this.git.status().call();
        }
        catch (Exception e) {
            LOG.error("There was an error in Git " + operation + " operation");
            throw e;
        }
        exchange.getOut().setBody((Object)status);
    }

    protected void doLog(Exchange exchange, String operation) throws Exception {
        Iterable revCommit = null;
        try {
            if (ObjectHelper.isNotEmpty((Object)this.endpoint.getBranchName())) {
                this.git.checkout().setCreateBranch(false).setName(this.endpoint.getBranchName()).call();
            }
            revCommit = this.git.log().call();
        }
        catch (Exception e) {
            LOG.error("There was an error in Git " + operation + " operation");
            throw e;
        }
        exchange.getOut().setBody((Object)revCommit);
    }

    protected void doPush(Exchange exchange, String operation) throws Exception {
        Iterable result = null;
        try {
            if (ObjectHelper.isEmpty((Object)this.endpoint.getRemotePath())) {
                throw new IllegalArgumentException("Remote path must be specified to execute " + operation);
            }
            if (ObjectHelper.isNotEmpty((Object)this.endpoint.getBranchName())) {
                this.git.checkout().setCreateBranch(false).setName(this.endpoint.getBranchName()).call();
            }
            if (ObjectHelper.isNotEmpty((Object)this.endpoint.getUsername()) && ObjectHelper.isNotEmpty((Object)this.endpoint.getPassword())) {
                UsernamePasswordCredentialsProvider credentials = new UsernamePasswordCredentialsProvider(this.endpoint.getUsername(), this.endpoint.getPassword());
                result = ((PushCommand)this.git.push().setCredentialsProvider((CredentialsProvider)credentials)).setRemote(this.endpoint.getRemotePath()).call();
            } else {
                result = this.git.push().setRemote(this.endpoint.getRemotePath()).call();
            }
        }
        catch (Exception e) {
            LOG.error("There was an error in Git " + operation + " operation");
            throw e;
        }
        exchange.getOut().setBody((Object)result);
    }

    protected void doPull(Exchange exchange, String operation) throws Exception {
        PullResult result = null;
        try {
            if (ObjectHelper.isEmpty((Object)this.endpoint.getRemotePath())) {
                throw new IllegalArgumentException("Remote path must be specified to execute " + operation);
            }
            if (ObjectHelper.isNotEmpty((Object)this.endpoint.getBranchName())) {
                this.git.checkout().setCreateBranch(false).setName(this.endpoint.getBranchName()).call();
            }
            if (ObjectHelper.isNotEmpty((Object)this.endpoint.getUsername()) && ObjectHelper.isNotEmpty((Object)this.endpoint.getPassword())) {
                UsernamePasswordCredentialsProvider credentials = new UsernamePasswordCredentialsProvider(this.endpoint.getUsername(), this.endpoint.getPassword());
                result = ((PullCommand)this.git.pull().setCredentialsProvider((CredentialsProvider)credentials)).setRemote(this.endpoint.getRemotePath()).call();
            } else {
                result = this.git.pull().setRemote(this.endpoint.getRemotePath()).call();
            }
        }
        catch (Exception e) {
            LOG.error("There was an error in Git " + operation + " operation");
            throw e;
        }
        exchange.getOut().setBody((Object)result);
    }

    protected void doCreateTag(Exchange exchange, String operation) throws Exception {
        if (ObjectHelper.isEmpty((Object)this.endpoint.getTagName())) {
            throw new IllegalArgumentException("Tag Name must be specified to execute " + operation);
        }
        try {
            this.git.tag().setName(this.endpoint.getTagName()).call();
        }
        catch (Exception e) {
            LOG.error("There was an error in Git " + operation + " operation");
            throw e;
        }
    }

    protected void doDeleteTag(Exchange exchange, String operation) throws Exception {
        if (ObjectHelper.isEmpty((Object)this.endpoint.getTagName())) {
            throw new IllegalArgumentException("Tag Name must be specified to execute " + operation);
        }
        try {
            this.git.tagDelete().setTags(new String[]{this.endpoint.getTagName()}).call();
        }
        catch (Exception e) {
            LOG.error("There was an error in Git " + operation + " operation");
            throw e;
        }
    }

    protected void doShowBranches(Exchange exchange, String operation) throws Exception {
        List result = null;
        try {
            result = this.git.branchList().setListMode(ListBranchCommand.ListMode.ALL).call();
        }
        catch (Exception e) {
            LOG.error("There was an error in Git " + operation + " operation");
            throw e;
        }
        exchange.getOut().setBody((Object)result);
    }

    private Repository getLocalRepository() throws IOException {
        FileRepositoryBuilder builder = new FileRepositoryBuilder();
        Repository repo = null;
        try {
            repo = ((FileRepositoryBuilder)((FileRepositoryBuilder)((FileRepositoryBuilder)builder.setGitDir(new File(this.endpoint.getLocalPath(), ".git"))).readEnvironment()).findGitDir()).build();
        }
        catch (IOException e) {
            LOG.error("There was an error, cannot open " + this.endpoint.getLocalPath() + " repository");
            throw e;
        }
        return repo;
    }
}

