/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kafka;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;
import kafka.javaapi.producer.Producer;
import kafka.producer.KeyedMessage;
import kafka.producer.ProducerConfig;
import org.apache.camel.CamelException;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.kafka.KafkaEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.util.CastUtils;

public class KafkaProducer<K, V>
extends DefaultProducer {
    protected Producer<K, V> producer;
    private final KafkaEndpoint endpoint;

    public KafkaProducer(KafkaEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
    }

    protected void doStop() throws Exception {
        if (this.producer != null) {
            this.producer.close();
        }
    }

    Properties getProps() {
        Properties props = this.endpoint.getConfiguration().createProducerProperties();
        if (this.endpoint.getBrokers() != null) {
            props.put("metadata.broker.list", this.endpoint.getBrokers());
        }
        return props;
    }

    protected void doStart() throws Exception {
        Properties props = this.getProps();
        ProducerConfig config = new ProducerConfig(props);
        this.producer = new Producer(config);
    }

    public void process(Exchange exchange) throws CamelException {
        String topic = this.endpoint.getTopic();
        if (!this.endpoint.isBridgeEndpoint()) {
            topic = (String)exchange.getIn().getHeader("kafka.TOPIC", (Object)topic, String.class);
        }
        if (topic == null) {
            throw new CamelExchangeException("No topic key set", exchange);
        }
        Object partitionKey = exchange.getIn().getHeader("kafka.PARTITION_KEY");
        boolean hasPartitionKey = partitionKey != null;
        Object messageKey = exchange.getIn().getHeader("kafka.KEY");
        boolean hasMessageKey = messageKey != null;
        Iterator msg = exchange.getIn().getBody();
        if (msg instanceof Iterable) {
            msg = ((Iterable)((Object)msg)).iterator();
        }
        if (msg instanceof Iterator) {
            LinkedList<KeyedMessage> data = new LinkedList<KeyedMessage>();
            Iterator it = CastUtils.cast(msg);
            while (it.hasNext()) {
                Object m = it.next();
                if (hasPartitionKey && hasMessageKey) {
                    data.add(new KeyedMessage(topic, messageKey, partitionKey, m));
                    continue;
                }
                if (hasPartitionKey) {
                    data.add(new KeyedMessage(topic, partitionKey, m));
                    continue;
                }
                if (hasMessageKey) {
                    data.add(new KeyedMessage(topic, messageKey, m));
                    continue;
                }
                data.add(new KeyedMessage(topic, messageKey, partitionKey, m));
            }
            this.producer.send(data);
        } else {
            Iterator m = msg;
            KeyedMessage data = hasPartitionKey && hasMessageKey ? new KeyedMessage(topic, messageKey, partitionKey, m) : (hasPartitionKey ? new KeyedMessage(topic, partitionKey, m) : (hasMessageKey ? new KeyedMessage(topic, messageKey, m) : new KeyedMessage(topic, messageKey, partitionKey, m)));
            this.producer.send(data);
        }
    }
}

