/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kafka;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.component.kafka.KafkaConfiguration;
import org.apache.camel.component.kafka.KafkaEndpoint;
import org.apache.camel.impl.UriEndpointComponent;
import org.apache.camel.util.CamelContextHelper;
import org.apache.camel.util.EndpointHelper;

public class KafkaComponent
extends UriEndpointComponent {
    public KafkaComponent() {
        super(KafkaEndpoint.class);
    }

    public KafkaComponent(CamelContext context) {
        super(context, KafkaEndpoint.class);
    }

    protected KafkaEndpoint createEndpoint(String uri, String remaining, Map<String, Object> params) throws Exception {
        KafkaEndpoint endpoint = new KafkaEndpoint(uri, this);
        String brokers = remaining.split("\\?")[0];
        Object confparam = params.get("configuration");
        if (confparam != null) {
            KafkaConfiguration confobj = null;
            if (confparam instanceof KafkaConfiguration) {
                confobj = (KafkaConfiguration)confparam;
            } else if (confparam instanceof String && EndpointHelper.isReferenceParameter((String)((String)confparam))) {
                confobj = (KafkaConfiguration)CamelContextHelper.lookup((CamelContext)this.getCamelContext(), (String)((String)confparam).substring(1));
            }
            if (confobj != null) {
                endpoint.setConfiguration(confobj.copy());
            }
            params.remove("configuration");
        }
        if (brokers != null) {
            endpoint.getConfiguration().setBrokers(brokers);
        }
        this.setProperties((Object)endpoint, params);
        return endpoint;
    }
}

