/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util.jsse;

import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.camel.CamelContext;
import org.apache.camel.util.jsse.AbstractJsseParametersTest;
import org.apache.camel.util.jsse.KeyStoreParameters;
import org.apache.camel.util.jsse.TrustManagersParameters;

public class TrustManagersParametersTest
extends AbstractJsseParametersTest {
    protected KeyStoreParameters createMinimalKeyStoreParameters() {
        KeyStoreParameters ksp = new KeyStoreParameters();
        ksp.setResource("org/apache/camel/util/jsse/localhost.ks");
        ksp.setPassword("changeit");
        return ksp;
    }

    protected TrustManagersParameters createMinimalTrustManagersParameters() {
        TrustManagersParameters tmp = new TrustManagersParameters();
        tmp.setKeyStore(this.createMinimalKeyStoreParameters());
        return tmp;
    }

    public void testPropertyPlaceholders() throws Exception {
        CamelContext context = this.createPropertiesPlaceholderAwareContext();
        KeyStoreParameters ksp = new KeyStoreParameters();
        ksp.setCamelContext(context);
        ksp.setType("{{keyStoreParameters.type}}");
        ksp.setProvider("{{keyStoreParameters.provider}}");
        ksp.setResource("{{keyStoreParameters.resource}}");
        ksp.setPassword("{{keyStoreParamerers.password}}");
        TrustManagersParameters tmp = new TrustManagersParameters();
        tmp.setCamelContext(context);
        tmp.setKeyStore(ksp);
        tmp.setAlgorithm("{{trustManagersParameters.algorithm}}");
        tmp.setProvider("{{trustManagersParameters.provider}}");
        TrustManager[] tms = tmp.createTrustManagers();
        this.validateTrustManagers(tms);
    }

    public void testCreateTrustManagers() throws Exception {
        TrustManagersParameters tmp = this.createMinimalTrustManagersParameters();
        TrustManager[] tms = tmp.createTrustManagers();
        this.validateTrustManagers(tms);
    }

    public void testExplicitAlgorithm() throws Exception {
        TrustManagersParameters tmp = this.createMinimalTrustManagersParameters();
        tmp.setAlgorithm(KeyManagerFactory.getDefaultAlgorithm());
        TrustManager[] tms = tmp.createTrustManagers();
        this.validateTrustManagers(tms);
    }

    public void testExplicitProvider() throws Exception {
        TrustManagersParameters tmp = this.createMinimalTrustManagersParameters();
        tmp.setProvider(KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm()).getProvider().getName());
        TrustManager[] tms = tmp.createTrustManagers();
        this.validateTrustManagers(tms);
    }

    public void testInvalidExplicitAlgorithm() throws Exception {
        TrustManagersParameters tmp = this.createMinimalTrustManagersParameters();
        tmp.setAlgorithm("dsfsdfsdfdsfdsF");
        try {
            tmp.createTrustManagers();
            TrustManagersParametersTest.fail();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
    }

    public void testInvalidExplicitProvider() throws Exception {
        TrustManagersParameters tmp = this.createMinimalTrustManagersParameters();
        tmp.setProvider("dsfsdfsdfdsfdsF");
        try {
            tmp.createTrustManagers();
            TrustManagersParametersTest.fail();
        }
        catch (NoSuchProviderException noSuchProviderException) {
            // empty catch block
        }
    }

    protected void validateTrustManagers(TrustManager[] tms) {
        TrustManagersParametersTest.assertEquals((int)1, (int)tms.length);
        TrustManagersParametersTest.assertTrue((boolean)(tms[0] instanceof X509TrustManager));
        X509TrustManager tm = (X509TrustManager)tms[0];
        TrustManagersParametersTest.assertNotNull((Object)tm.getAcceptedIssuers());
    }
}

