/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import org.apache.camel.CamelContext;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.util.PlatformHelper;
import org.junit.Assert;
import org.junit.Test;

public class PlatformHelperTest
extends Assert {
    @Test
    public void shouldNotMatchDefaultCamelContext() {
        PlatformHelperTest.assertFalse((boolean)PlatformHelper.isOsgiContext((CamelContext)new DefaultCamelContext()));
    }

    @Test
    public void shouldMatchBlueprintCamelContext() {
        PlatformHelperTest.assertTrue((boolean)PlatformHelper.isOsgiContext((CamelContext)new BlueprintCamelContext()));
    }

    @Test
    public void shouldMatchOsgiDefaultCamelContext() {
        PlatformHelperTest.assertTrue((boolean)PlatformHelper.isOsgiContext((CamelContext)new OsgiDefaultCamelContext()));
    }

    private class OsgiDefaultCamelContext
    extends DefaultCamelContext {
        private OsgiDefaultCamelContext() {
        }
    }

    private class BlueprintCamelContext
    extends DefaultCamelContext {
        private BlueprintCamelContext() {
        }
    }
}

