/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.util.List;
import junit.framework.TestCase;
import org.apache.camel.util.OgnlHelper;

public class OgnlHelperTest
extends TestCase {
    public void testSplitOgnlSimple() throws Exception {
        List methods = OgnlHelper.splitOgnl(null);
        OgnlHelperTest.assertEquals((int)0, (int)methods.size());
        methods = OgnlHelper.splitOgnl((String)"");
        OgnlHelperTest.assertEquals((int)0, (int)methods.size());
        methods = OgnlHelper.splitOgnl((String)" ");
        OgnlHelperTest.assertEquals((int)0, (int)methods.size());
        methods = OgnlHelper.splitOgnl((String)"foo");
        OgnlHelperTest.assertEquals((int)1, (int)methods.size());
        OgnlHelperTest.assertEquals((String)"foo", (String)((String)methods.get(0)));
        methods = OgnlHelper.splitOgnl((String)"foo.bar");
        OgnlHelperTest.assertEquals((int)2, (int)methods.size());
        OgnlHelperTest.assertEquals((String)"foo", (String)((String)methods.get(0)));
        OgnlHelperTest.assertEquals((String)".bar", (String)((String)methods.get(1)));
        methods = OgnlHelper.splitOgnl((String)"foo.bar.baz");
        OgnlHelperTest.assertEquals((int)3, (int)methods.size());
        OgnlHelperTest.assertEquals((String)"foo", (String)((String)methods.get(0)));
        OgnlHelperTest.assertEquals((String)".bar", (String)((String)methods.get(1)));
        OgnlHelperTest.assertEquals((String)".baz", (String)((String)methods.get(2)));
    }

    public void testSplitOgnlSquare() throws Exception {
        List methods = OgnlHelper.splitOgnl((String)"foo");
        OgnlHelperTest.assertEquals((int)1, (int)methods.size());
        OgnlHelperTest.assertEquals((String)"foo", (String)((String)methods.get(0)));
        methods = OgnlHelper.splitOgnl((String)"foo[0].bar");
        OgnlHelperTest.assertEquals((int)2, (int)methods.size());
        OgnlHelperTest.assertEquals((String)"foo[0]", (String)((String)methods.get(0)));
        OgnlHelperTest.assertEquals((String)".bar", (String)((String)methods.get(1)));
        methods = OgnlHelper.splitOgnl((String)"foo[0]?.bar");
        OgnlHelperTest.assertEquals((int)2, (int)methods.size());
        OgnlHelperTest.assertEquals((String)"foo[0]", (String)((String)methods.get(0)));
        OgnlHelperTest.assertEquals((String)"?.bar", (String)((String)methods.get(1)));
        methods = OgnlHelper.splitOgnl((String)"foo['key'].bar");
        OgnlHelperTest.assertEquals((int)2, (int)methods.size());
        OgnlHelperTest.assertEquals((String)"foo['key']", (String)((String)methods.get(0)));
        OgnlHelperTest.assertEquals((String)".bar", (String)((String)methods.get(1)));
        methods = OgnlHelper.splitOgnl((String)"foo['key']?.bar");
        OgnlHelperTest.assertEquals((int)2, (int)methods.size());
        OgnlHelperTest.assertEquals((String)"foo['key']", (String)((String)methods.get(0)));
        OgnlHelperTest.assertEquals((String)"?.bar", (String)((String)methods.get(1)));
        methods = OgnlHelper.splitOgnl((String)"foo['key'].bar[0]");
        OgnlHelperTest.assertEquals((int)2, (int)methods.size());
        OgnlHelperTest.assertEquals((String)"foo['key']", (String)((String)methods.get(0)));
        OgnlHelperTest.assertEquals((String)".bar[0]", (String)((String)methods.get(1)));
        methods = OgnlHelper.splitOgnl((String)"foo['key']?.bar[0]");
        OgnlHelperTest.assertEquals((int)2, (int)methods.size());
        OgnlHelperTest.assertEquals((String)"foo['key']", (String)((String)methods.get(0)));
        OgnlHelperTest.assertEquals((String)"?.bar[0]", (String)((String)methods.get(1)));
    }

    public void testSplitOgnlParenthesis() throws Exception {
        List methods = OgnlHelper.splitOgnl((String)"foo()");
        OgnlHelperTest.assertEquals((int)1, (int)methods.size());
        OgnlHelperTest.assertEquals((String)"foo()", (String)((String)methods.get(0)));
        methods = OgnlHelper.splitOgnl((String)"foo(${body})");
        OgnlHelperTest.assertEquals((int)1, (int)methods.size());
        OgnlHelperTest.assertEquals((String)"foo(${body})", (String)((String)methods.get(0)));
        methods = OgnlHelper.splitOgnl((String)"foo(${body}, ${header.foo})");
        OgnlHelperTest.assertEquals((int)1, (int)methods.size());
        OgnlHelperTest.assertEquals((String)"foo(${body}, ${header.foo})", (String)((String)methods.get(0)));
        methods = OgnlHelper.splitOgnl((String)"foo(${body}, ${header.foo}).bar");
        OgnlHelperTest.assertEquals((int)2, (int)methods.size());
        OgnlHelperTest.assertEquals((String)"foo(${body}, ${header.foo})", (String)((String)methods.get(0)));
        OgnlHelperTest.assertEquals((String)".bar", (String)((String)methods.get(1)));
        methods = OgnlHelper.splitOgnl((String)"foo(${body}, ${header.foo}).bar(true, ${header.bar})");
        OgnlHelperTest.assertEquals((int)2, (int)methods.size());
        OgnlHelperTest.assertEquals((String)"foo(${body}, ${header.foo})", (String)((String)methods.get(0)));
        OgnlHelperTest.assertEquals((String)".bar(true, ${header.bar})", (String)((String)methods.get(1)));
        methods = OgnlHelper.splitOgnl((String)"foo(${body}, ${header.foo}).bar(true, ${header.bar}).baz['key']");
        OgnlHelperTest.assertEquals((int)3, (int)methods.size());
        OgnlHelperTest.assertEquals((String)"foo(${body}, ${header.foo})", (String)((String)methods.get(0)));
        OgnlHelperTest.assertEquals((String)".bar(true, ${header.bar})", (String)((String)methods.get(1)));
        OgnlHelperTest.assertEquals((String)".baz['key']", (String)((String)methods.get(2)));
    }

    public void testSplitOgnlParenthesisAndBracket() throws Exception {
        List methods = OgnlHelper.splitOgnl((String)"foo(${body['key']})");
        OgnlHelperTest.assertEquals((int)1, (int)methods.size());
        OgnlHelperTest.assertEquals((String)"foo(${body['key']})", (String)((String)methods.get(0)));
        methods = OgnlHelper.splitOgnl((String)"foo(${body}, ${header.foo?['key']})");
        OgnlHelperTest.assertEquals((int)1, (int)methods.size());
        OgnlHelperTest.assertEquals((String)"foo(${body}, ${header.foo?['key']})", (String)((String)methods.get(0)));
        methods = OgnlHelper.splitOgnl((String)"foo(${body}, ${header.foo}).bar(true, ${header.bar[0]?.code})");
        OgnlHelperTest.assertEquals((int)2, (int)methods.size());
        OgnlHelperTest.assertEquals((String)"foo(${body}, ${header.foo})", (String)((String)methods.get(0)));
        OgnlHelperTest.assertEquals((String)".bar(true, ${header.bar[0]?.code})", (String)((String)methods.get(1)));
    }
}

