/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.camel.Message;
import org.apache.camel.converter.IOConverter;
import org.apache.camel.impl.DefaultMessage;
import org.apache.camel.util.GZIPHelper;
import org.junit.Assert;
import org.junit.Test;

public class GZIPHelperTest {
    private static byte[] sampleBytes = new byte[]{1, 2, 3, 1, 2, 3};
    private static String sampleString = "<Hello>World</Hello>";

    @Test
    public void toGZIPInputStreamShouldReturnTheSameInputStream() throws IOException {
        InputStream inputStream = GZIPHelper.uncompressGzip((String)"text", (InputStream)new ByteArrayInputStream(sampleBytes));
        byte[] bytes = new byte[6];
        inputStream.read(bytes);
        Assert.assertEquals((long)-1L, (long)inputStream.read());
        Assert.assertArrayEquals((byte[])sampleBytes, (byte[])bytes);
    }

    @Test
    public void toGZIPInputStreamShouldReturnAByteArrayInputStream() throws IOException {
        InputStream inputStream = GZIPHelper.compressGzip((String)"text", (byte[])sampleBytes);
        byte[] bytes = IOConverter.toBytes((InputStream)inputStream);
        Assert.assertArrayEquals((byte[])sampleBytes, (byte[])bytes);
    }

    @Test
    public void testCompressAndUnCompressData() throws IOException {
        InputStream inputStream = GZIPHelper.compressGzip((String)"gzip", (InputStream)new ByteArrayInputStream(sampleString.getBytes()));
        Assert.assertNotNull((String)"The inputStream should not be null.", (Object)inputStream);
        inputStream = GZIPHelper.uncompressGzip((String)"gzip", (InputStream)inputStream);
        String result = IOConverter.toString((InputStream)inputStream, null);
        Assert.assertEquals((String)"The result is wrong.", (Object)sampleString, (Object)result);
    }

    @Test
    public void testIsGzipMessage() {
        Assert.assertTrue((boolean)GZIPHelper.isGzip((Message)this.createMessageWithContentEncodingHeader("gzip")));
        Assert.assertTrue((boolean)GZIPHelper.isGzip((Message)this.createMessageWithContentEncodingHeader("GZip")));
        Assert.assertFalse((boolean)GZIPHelper.isGzip((Message)this.createMessageWithContentEncodingHeader(null)));
        Assert.assertFalse((boolean)GZIPHelper.isGzip((Message)this.createMessageWithContentEncodingHeader("zip")));
    }

    @Test
    public void isGzipString() {
        Assert.assertTrue((boolean)GZIPHelper.isGzip((String)"gzip"));
        Assert.assertTrue((boolean)GZIPHelper.isGzip((String)"GZip"));
        Assert.assertFalse((boolean)GZIPHelper.isGzip((String)null));
        Assert.assertFalse((boolean)GZIPHelper.isGzip((String)"zip"));
    }

    private Message createMessageWithContentEncodingHeader(String contentEncoding) {
        DefaultMessage msg = new DefaultMessage();
        msg.setHeader("Content-Encoding", (Object)contentEncoding);
        return msg;
    }
}

