/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.NamedNode;
import org.apache.camel.Route;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.properties.PropertiesComponent;
import org.apache.camel.model.ModelHelper;
import org.apache.camel.model.RouteDefinition;

public class DumpModelAsXmlPlaceholdersTest
extends ContextTestSupport {
    public void testDumpModelAsXml() throws Exception {
        DumpModelAsXmlPlaceholdersTest.assertEquals((String)"Gouda", (String)((Route)this.context.getRoutes().get(0)).getId());
        String xml = ModelHelper.dumpModelAsXml((CamelContext)this.context, (NamedNode)this.context.getRouteDefinition("Gouda"));
        DumpModelAsXmlPlaceholdersTest.assertNotNull((Object)xml);
        this.log.info(xml);
        DumpModelAsXmlPlaceholdersTest.assertTrue((boolean)xml.contains("<route customId=\"true\" id=\"Gouda\" xmlns=\"http://camel.apache.org/schema/spring\">"));
        DumpModelAsXmlPlaceholdersTest.assertTrue((boolean)xml.contains("<from uri=\"direct:start-{{cheese.type}}\"/>"));
        DumpModelAsXmlPlaceholdersTest.assertTrue((boolean)xml.contains("<to uri=\"direct:end-{{cheese.type}}\" customId=\"true\" id=\"log\"/>"));
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start-{{cheese.type}}").routeId("{{cheese.type}}").to("direct:end-{{cheese.type}}")).id("log");
            }
        };
    }

    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        PropertiesComponent component = new PropertiesComponent();
        component.setCamelContext(context);
        component.setLocation("classpath:org/apache/camel/component/properties/cheese.properties");
        context.addComponent("properties", (Component)component);
        return context;
    }
}

