/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import junit.framework.TestCase;
import org.apache.camel.util.CollectionHelper;

public class CollectionHelperTest
extends TestCase {
    private String[] names = new String[]{"Claus", "Willem", "Jonathan"};
    private List<String> list = Arrays.asList(this.names);

    public void testCollectionAsCommaDelimitedString() {
        CollectionHelperTest.assertEquals((String)"Claus,Willem,Jonathan", (String)CollectionHelper.collectionAsCommaDelimitedString((String[])this.names));
        CollectionHelperTest.assertEquals((String)"Claus,Willem,Jonathan", (String)CollectionHelper.collectionAsCommaDelimitedString(this.list));
        CollectionHelperTest.assertEquals((String)"", (String)CollectionHelper.collectionAsCommaDelimitedString((String[])null));
        CollectionHelperTest.assertEquals((String)"", (String)CollectionHelper.collectionAsCommaDelimitedString((Collection)null));
        CollectionHelperTest.assertEquals((String)"Claus", (String)CollectionHelper.collectionAsCommaDelimitedString((String[])new String[]{"Claus"}));
    }

    public void testSize() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("foo", 123);
        map.put("bar", 456);
        CollectionHelperTest.assertEquals((int)2, (int)CollectionHelper.size(map));
        String[] array = new String[]{"Claus", "Willem"};
        CollectionHelperTest.assertEquals((int)2, (int)CollectionHelper.size((Object)array));
    }

    public void testAppendValue() {
        HashMap map = new HashMap();
        CollectionHelper.appendValue(map, (String)"foo", (Object)123);
        CollectionHelperTest.assertEquals((int)1, (int)map.size());
        CollectionHelper.appendValue(map, (String)"foo", (Object)456);
        CollectionHelperTest.assertEquals((int)1, (int)map.size());
        CollectionHelper.appendValue(map, (String)"bar", (Object)789);
        CollectionHelperTest.assertEquals((int)2, (int)map.size());
        List values = (List)map.get("foo");
        CollectionHelperTest.assertEquals((int)2, (int)values.size());
        CollectionHelperTest.assertEquals((Object)123, values.get(0));
        CollectionHelperTest.assertEquals((Object)456, values.get(1));
        Integer value = (Integer)map.get("bar");
        CollectionHelperTest.assertEquals((int)789, (int)value);
    }
}

