/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import junit.framework.TestCase;
import org.apache.camel.util.CaseInsensitiveMap;

public class CaseInsensitiveMapTest
extends TestCase {
    public void testLookupCaseAgnostic() {
        CaseInsensitiveMap map = new CaseInsensitiveMap();
        CaseInsensitiveMapTest.assertNull(map.get("foo"));
        map.put("foo", "cheese");
        CaseInsensitiveMapTest.assertEquals((Object)"cheese", map.get("foo"));
        CaseInsensitiveMapTest.assertEquals((Object)"cheese", map.get("Foo"));
        CaseInsensitiveMapTest.assertEquals((Object)"cheese", map.get("FOO"));
    }

    public void testLookupCaseAgnosticAddHeader() {
        CaseInsensitiveMap map = new CaseInsensitiveMap();
        CaseInsensitiveMapTest.assertNull(map.get("foo"));
        map.put("foo", "cheese");
        CaseInsensitiveMapTest.assertEquals((Object)"cheese", map.get("foo"));
        CaseInsensitiveMapTest.assertEquals((Object)"cheese", map.get("Foo"));
        CaseInsensitiveMapTest.assertEquals((Object)"cheese", map.get("FOO"));
        CaseInsensitiveMapTest.assertNull(map.get("unknown"));
        map.put("bar", "beer");
        CaseInsensitiveMapTest.assertEquals((Object)"beer", map.get("bar"));
        CaseInsensitiveMapTest.assertEquals((Object)"beer", map.get("Bar"));
        CaseInsensitiveMapTest.assertEquals((Object)"beer", map.get("BAR"));
        CaseInsensitiveMapTest.assertNull(map.get("unknown"));
    }

    public void testLookupCaseAgnosticAddHeader2() {
        CaseInsensitiveMap map = new CaseInsensitiveMap();
        CaseInsensitiveMapTest.assertNull(map.get("foo"));
        map.put("foo", "cheese");
        CaseInsensitiveMapTest.assertEquals((Object)"cheese", map.get("FOO"));
        CaseInsensitiveMapTest.assertEquals((Object)"cheese", map.get("foo"));
        CaseInsensitiveMapTest.assertEquals((Object)"cheese", map.get("Foo"));
        CaseInsensitiveMapTest.assertNull(map.get("unknown"));
        map.put("bar", "beer");
        CaseInsensitiveMapTest.assertEquals((Object)"beer", map.get("BAR"));
        CaseInsensitiveMapTest.assertEquals((Object)"beer", map.get("bar"));
        CaseInsensitiveMapTest.assertEquals((Object)"beer", map.get("Bar"));
        CaseInsensitiveMapTest.assertNull(map.get("unknown"));
    }

    public void testLookupCaseAgnosticAddHeaderRemoveHeader() {
        CaseInsensitiveMap map = new CaseInsensitiveMap();
        CaseInsensitiveMapTest.assertNull(map.get("foo"));
        map.put("foo", "cheese");
        CaseInsensitiveMapTest.assertEquals((Object)"cheese", map.get("foo"));
        CaseInsensitiveMapTest.assertEquals((Object)"cheese", map.get("Foo"));
        CaseInsensitiveMapTest.assertEquals((Object)"cheese", map.get("FOO"));
        CaseInsensitiveMapTest.assertNull(map.get("unknown"));
        map.put("bar", "beer");
        CaseInsensitiveMapTest.assertEquals((Object)"beer", map.get("bar"));
        CaseInsensitiveMapTest.assertEquals((Object)"beer", map.get("Bar"));
        CaseInsensitiveMapTest.assertEquals((Object)"beer", map.get("BAR"));
        CaseInsensitiveMapTest.assertNull(map.get("unknown"));
        map.remove("bar");
        CaseInsensitiveMapTest.assertNull(map.get("bar"));
        CaseInsensitiveMapTest.assertNull(map.get("unknown"));
    }

    public void testSetWithDifferentCase() {
        CaseInsensitiveMap map = new CaseInsensitiveMap();
        CaseInsensitiveMapTest.assertNull(map.get("foo"));
        map.put("foo", "cheese");
        map.put("Foo", "bar");
        CaseInsensitiveMapTest.assertEquals((Object)"bar", map.get("FOO"));
        CaseInsensitiveMapTest.assertEquals((Object)"bar", map.get("foo"));
        CaseInsensitiveMapTest.assertEquals((Object)"bar", map.get("Foo"));
    }

    public void testRemoveWithDifferentCase() {
        CaseInsensitiveMap map = new CaseInsensitiveMap();
        CaseInsensitiveMapTest.assertNull(map.get("foo"));
        map.put("foo", "cheese");
        map.put("Foo", "bar");
        CaseInsensitiveMapTest.assertEquals((Object)"bar", map.get("FOO"));
        CaseInsensitiveMapTest.assertEquals((Object)"bar", map.get("foo"));
        CaseInsensitiveMapTest.assertEquals((Object)"bar", map.get("Foo"));
        map.remove("FOO");
        CaseInsensitiveMapTest.assertEquals(null, map.get("foo"));
        CaseInsensitiveMapTest.assertEquals(null, map.get("Foo"));
        CaseInsensitiveMapTest.assertEquals(null, map.get("FOO"));
        CaseInsensitiveMapTest.assertTrue((boolean)map.isEmpty());
    }

    public void testPutAll() {
        CaseInsensitiveMap map = new CaseInsensitiveMap();
        CaseInsensitiveMapTest.assertNull(map.get("foo"));
        CaseInsensitiveMap other = new CaseInsensitiveMap();
        other.put("Foo", "cheese");
        other.put("bar", 123);
        map.putAll(other);
        CaseInsensitiveMapTest.assertEquals((Object)"cheese", map.get("FOO"));
        CaseInsensitiveMapTest.assertEquals((Object)"cheese", map.get("foo"));
        CaseInsensitiveMapTest.assertEquals((Object)"cheese", map.get("Foo"));
        CaseInsensitiveMapTest.assertEquals((Object)123, map.get("BAR"));
        CaseInsensitiveMapTest.assertEquals((Object)123, map.get("bar"));
        CaseInsensitiveMapTest.assertEquals((Object)123, map.get("BaR"));
        HashMap keys = new HashMap();
        keys.putAll(map);
        CaseInsensitiveMapTest.assertEquals((Object)"cheese", keys.get("Foo"));
        CaseInsensitiveMapTest.assertNull(keys.get("foo"));
        CaseInsensitiveMapTest.assertNull(keys.get("FOO"));
        CaseInsensitiveMapTest.assertEquals((Object)123, keys.get("bar"));
        CaseInsensitiveMapTest.assertNull(keys.get("Bar"));
        CaseInsensitiveMapTest.assertNull(keys.get("BAR"));
    }

    public void testPutAllOther() {
        CaseInsensitiveMap map = new CaseInsensitiveMap();
        CaseInsensitiveMapTest.assertNull(map.get("foo"));
        HashMap<String, Object> other = new HashMap<String, Object>();
        other.put("Foo", "cheese");
        other.put("bar", 123);
        map.putAll(other);
        CaseInsensitiveMapTest.assertEquals((Object)"cheese", map.get("FOO"));
        CaseInsensitiveMapTest.assertEquals((Object)"cheese", map.get("foo"));
        CaseInsensitiveMapTest.assertEquals((Object)"cheese", map.get("Foo"));
        CaseInsensitiveMapTest.assertEquals((Object)123, map.get("BAR"));
        CaseInsensitiveMapTest.assertEquals((Object)123, map.get("bar"));
        CaseInsensitiveMapTest.assertEquals((Object)123, map.get("BaR"));
    }

    public void testPutAllEmpty() {
        CaseInsensitiveMap map = new CaseInsensitiveMap();
        map.put("foo", "cheese");
        HashMap other = new HashMap();
        map.putAll(other);
        CaseInsensitiveMapTest.assertEquals((Object)"cheese", map.get("FOO"));
        CaseInsensitiveMapTest.assertEquals((Object)"cheese", map.get("foo"));
        CaseInsensitiveMapTest.assertEquals((Object)"cheese", map.get("Foo"));
        CaseInsensitiveMapTest.assertEquals((int)1, (int)map.size());
    }

    public void testConstructFromOther() {
        HashMap<String, Object> other = new HashMap<String, Object>();
        other.put("Foo", "cheese");
        other.put("bar", 123);
        CaseInsensitiveMap map = new CaseInsensitiveMap(other);
        CaseInsensitiveMapTest.assertEquals((Object)"cheese", map.get("FOO"));
        CaseInsensitiveMapTest.assertEquals((Object)"cheese", map.get("foo"));
        CaseInsensitiveMapTest.assertEquals((Object)"cheese", map.get("Foo"));
        CaseInsensitiveMapTest.assertEquals((Object)123, map.get("BAR"));
        CaseInsensitiveMapTest.assertEquals((Object)123, map.get("bar"));
        CaseInsensitiveMapTest.assertEquals((Object)123, map.get("BaR"));
    }

    public void testKeySet() {
        CaseInsensitiveMap map = new CaseInsensitiveMap();
        map.put("Foo", "cheese");
        map.put("BAR", 123);
        map.put("baZ", "beer");
        Set keys = map.keySet();
        CaseInsensitiveMapTest.assertTrue((boolean)keys.contains("Foo"));
        CaseInsensitiveMapTest.assertTrue((boolean)keys.contains("foo"));
        CaseInsensitiveMapTest.assertTrue((boolean)keys.contains("FOO"));
        CaseInsensitiveMapTest.assertTrue((boolean)keys.contains("BAR"));
        CaseInsensitiveMapTest.assertTrue((boolean)keys.contains("bar"));
        CaseInsensitiveMapTest.assertTrue((boolean)keys.contains("Bar"));
        CaseInsensitiveMapTest.assertTrue((boolean)keys.contains("baZ"));
        CaseInsensitiveMapTest.assertTrue((boolean)keys.contains("baz"));
        CaseInsensitiveMapTest.assertTrue((boolean)keys.contains("Baz"));
        CaseInsensitiveMapTest.assertTrue((boolean)keys.contains("BAZ"));
    }

    public void testRetainKeysCopyToAnotherMap() {
        CaseInsensitiveMap map = new CaseInsensitiveMap();
        map.put("Foo", "cheese");
        map.put("BAR", 123);
        map.put("baZ", "beer");
        HashMap other = new HashMap(map);
        CaseInsensitiveMapTest.assertTrue((boolean)other.containsKey("Foo"));
        CaseInsensitiveMapTest.assertFalse((boolean)other.containsKey("foo"));
        CaseInsensitiveMapTest.assertFalse((boolean)other.containsKey("FOO"));
        CaseInsensitiveMapTest.assertTrue((boolean)other.containsKey("BAR"));
        CaseInsensitiveMapTest.assertFalse((boolean)other.containsKey("bar"));
        CaseInsensitiveMapTest.assertFalse((boolean)other.containsKey("Bar"));
        CaseInsensitiveMapTest.assertTrue((boolean)other.containsKey("baZ"));
        CaseInsensitiveMapTest.assertFalse((boolean)other.containsKey("baz"));
        CaseInsensitiveMapTest.assertFalse((boolean)other.containsKey("Baz"));
        CaseInsensitiveMapTest.assertFalse((boolean)other.containsKey("BAZ"));
    }

    public void testValues() {
        CaseInsensitiveMap map = new CaseInsensitiveMap();
        map.put("Foo", "cheese");
        map.put("BAR", "123");
        map.put("baZ", "Beer");
        Iterator it = map.values().iterator();
        CaseInsensitiveMapTest.assertEquals((String)"String", (String)it.next().getClass().getSimpleName());
        CaseInsensitiveMapTest.assertEquals((String)"String", (String)it.next().getClass().getSimpleName());
        CaseInsensitiveMapTest.assertEquals((String)"String", (String)it.next().getClass().getSimpleName());
        Collection values = map.values();
        CaseInsensitiveMapTest.assertEquals((int)3, (int)values.size());
        CaseInsensitiveMapTest.assertTrue((boolean)values.contains("cheese"));
        CaseInsensitiveMapTest.assertTrue((boolean)values.contains("123"));
        CaseInsensitiveMapTest.assertTrue((boolean)values.contains("Beer"));
    }

    public void testRomeks() {
        CaseInsensitiveMap map = new CaseInsensitiveMap();
        map.put("foo", "cheese");
        CaseInsensitiveMapTest.assertEquals((int)1, (int)map.size());
        CaseInsensitiveMapTest.assertEquals((Object)"cheese", map.get("fOo"));
        CaseInsensitiveMapTest.assertEquals((boolean)true, (boolean)map.containsKey("foo"));
        CaseInsensitiveMapTest.assertEquals((boolean)true, (boolean)map.containsKey("FOO"));
        CaseInsensitiveMapTest.assertEquals((boolean)true, (boolean)map.keySet().contains("FOO"));
        CaseInsensitiveMapTest.assertEquals((boolean)true, (boolean)map.keySet().contains("FoO"));
        CaseInsensitiveMapTest.assertEquals((boolean)true, (boolean)map.keySet().contains("Foo"));
        CaseInsensitiveMapTest.assertEquals((boolean)true, (boolean)map.keySet().contains("foo"));
        CaseInsensitiveMapTest.assertEquals((boolean)true, (boolean)map.keySet().contains("fOO"));
        map.put("FOO", "cake");
        CaseInsensitiveMapTest.assertEquals((int)1, (int)map.size());
        CaseInsensitiveMapTest.assertEquals((boolean)true, (boolean)map.containsKey("foo"));
        CaseInsensitiveMapTest.assertEquals((boolean)true, (boolean)map.containsKey("FOO"));
        CaseInsensitiveMapTest.assertEquals((Object)"cake", map.get("fOo"));
    }

    public void testRomeksUsingRegularHashMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("foo", "cheese");
        CaseInsensitiveMapTest.assertEquals((int)1, (int)map.size());
        CaseInsensitiveMapTest.assertEquals(null, map.get("fOo"));
        CaseInsensitiveMapTest.assertEquals((boolean)true, (boolean)map.containsKey("foo"));
        CaseInsensitiveMapTest.assertEquals((boolean)false, (boolean)map.containsKey("FOO"));
        CaseInsensitiveMapTest.assertEquals((boolean)false, (boolean)map.keySet().contains("FOO"));
        map.put("FOO", "cake");
        CaseInsensitiveMapTest.assertEquals((int)2, (int)map.size());
        CaseInsensitiveMapTest.assertEquals((boolean)true, (boolean)map.containsKey("foo"));
        CaseInsensitiveMapTest.assertEquals((boolean)true, (boolean)map.containsKey("FOO"));
        CaseInsensitiveMapTest.assertEquals(null, map.get("fOo"));
        CaseInsensitiveMapTest.assertEquals((Object)"cheese", map.get("foo"));
        CaseInsensitiveMapTest.assertEquals((Object)"cake", map.get("FOO"));
    }

    public void testRomeksTransferredToHashMapAfterwards() {
        CaseInsensitiveMap map = new CaseInsensitiveMap();
        map.put("Foo", "cheese");
        map.put("FOO", "cake");
        CaseInsensitiveMapTest.assertEquals((int)1, (int)map.size());
        CaseInsensitiveMapTest.assertEquals((boolean)true, (boolean)map.containsKey("foo"));
        CaseInsensitiveMapTest.assertEquals((boolean)true, (boolean)map.containsKey("FOO"));
        HashMap other = new HashMap(map);
        CaseInsensitiveMapTest.assertEquals((boolean)false, (boolean)other.containsKey("foo"));
        CaseInsensitiveMapTest.assertEquals((boolean)false, (boolean)other.containsKey("FOO"));
        CaseInsensitiveMapTest.assertEquals((boolean)true, (boolean)other.containsKey("Foo"));
        CaseInsensitiveMapTest.assertEquals((int)1, (int)other.size());
    }

    public void testSerialization() throws Exception {
        CaseInsensitiveMap testMap = new CaseInsensitiveMap();
        testMap.put((Object)"key", (Object)"value");
        testMap.entrySet();
        ByteArrayOutputStream bStream = new ByteArrayOutputStream();
        ObjectOutputStream objStream = new ObjectOutputStream(bStream);
        objStream.writeObject(testMap);
        ObjectInputStream inStream = new ObjectInputStream(new ByteArrayInputStream(bStream.toByteArray()));
        CaseInsensitiveMap testMapCopy = (CaseInsensitiveMap)inStream.readObject();
        CaseInsensitiveMapTest.assertTrue((boolean)testMapCopy.containsKey((Object)"key"));
    }

    public void testCopyToAnotherMapPreserveKeyCaseEntrySet() {
        CaseInsensitiveMap map = new CaseInsensitiveMap();
        map.put("Foo", "cheese");
        map.put("BAR", "cake");
        CaseInsensitiveMapTest.assertEquals((int)2, (int)map.size());
        CaseInsensitiveMapTest.assertEquals((boolean)true, (boolean)map.containsKey("foo"));
        CaseInsensitiveMapTest.assertEquals((boolean)true, (boolean)map.containsKey("bar"));
        HashMap other = new HashMap();
        for (Map.Entry entry : map.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            other.put(key, value);
        }
        CaseInsensitiveMapTest.assertEquals((boolean)false, (boolean)other.containsKey("foo"));
        CaseInsensitiveMapTest.assertEquals((boolean)true, (boolean)other.containsKey("Foo"));
        CaseInsensitiveMapTest.assertEquals((boolean)false, (boolean)other.containsKey("bar"));
        CaseInsensitiveMapTest.assertEquals((boolean)true, (boolean)other.containsKey("BAR"));
        CaseInsensitiveMapTest.assertEquals((int)2, (int)other.size());
    }

    public void testCopyToAnotherMapPreserveKeyCasePutAll() {
        CaseInsensitiveMap map = new CaseInsensitiveMap();
        map.put("Foo", "cheese");
        map.put("BAR", "cake");
        CaseInsensitiveMapTest.assertEquals((int)2, (int)map.size());
        CaseInsensitiveMapTest.assertEquals((boolean)true, (boolean)map.containsKey("foo"));
        CaseInsensitiveMapTest.assertEquals((boolean)true, (boolean)map.containsKey("bar"));
        HashMap other = new HashMap();
        other.putAll(map);
        CaseInsensitiveMapTest.assertEquals((boolean)false, (boolean)other.containsKey("foo"));
        CaseInsensitiveMapTest.assertEquals((boolean)true, (boolean)other.containsKey("Foo"));
        CaseInsensitiveMapTest.assertEquals((boolean)false, (boolean)other.containsKey("bar"));
        CaseInsensitiveMapTest.assertEquals((boolean)true, (boolean)other.containsKey("BAR"));
        CaseInsensitiveMapTest.assertEquals((int)2, (int)other.size());
    }

    public void testCopyToAnotherMapPreserveKeyCaseCtr() {
        CaseInsensitiveMap map = new CaseInsensitiveMap();
        map.put("Foo", "cheese");
        map.put("BAR", "cake");
        CaseInsensitiveMapTest.assertEquals((int)2, (int)map.size());
        CaseInsensitiveMapTest.assertEquals((boolean)true, (boolean)map.containsKey("foo"));
        CaseInsensitiveMapTest.assertEquals((boolean)true, (boolean)map.containsKey("bar"));
        HashMap other = new HashMap(map);
        CaseInsensitiveMapTest.assertEquals((boolean)false, (boolean)other.containsKey("foo"));
        CaseInsensitiveMapTest.assertEquals((boolean)true, (boolean)other.containsKey("Foo"));
        CaseInsensitiveMapTest.assertEquals((boolean)false, (boolean)other.containsKey("bar"));
        CaseInsensitiveMapTest.assertEquals((boolean)true, (boolean)other.containsKey("BAR"));
        CaseInsensitiveMapTest.assertEquals((int)2, (int)other.size());
    }

    public void testCopyToAnotherMapPreserveKeyKeySet() {
        CaseInsensitiveMap map = new CaseInsensitiveMap();
        map.put("Foo", "cheese");
        map.put("BAR", "cake");
        CaseInsensitiveMapTest.assertEquals((int)2, (int)map.size());
        CaseInsensitiveMapTest.assertEquals((boolean)true, (boolean)map.containsKey("foo"));
        CaseInsensitiveMapTest.assertEquals((boolean)true, (boolean)map.containsKey("bar"));
        HashMap other = new HashMap();
        for (String key : map.keySet()) {
            Object value = map.get(key);
            other.put(key, value);
        }
        CaseInsensitiveMapTest.assertEquals((boolean)false, (boolean)other.containsKey("foo"));
        CaseInsensitiveMapTest.assertEquals((boolean)true, (boolean)other.containsKey("Foo"));
        CaseInsensitiveMapTest.assertEquals((boolean)false, (boolean)other.containsKey("bar"));
        CaseInsensitiveMapTest.assertEquals((boolean)true, (boolean)other.containsKey("BAR"));
        CaseInsensitiveMapTest.assertEquals((int)2, (int)other.size());
    }

    public void testConcurrent() throws Exception {
        ExecutorService service = Executors.newFixedThreadPool(5);
        CountDownLatch latch = new CountDownLatch(1000);
        CaseInsensitiveMap map = new CaseInsensitiveMap();
        int i = 0;
        while (i < 1000) {
            final int count = i++;
            service.submit(new Runnable((Map)map, latch){
                final /* synthetic */ Map val$map;
                final /* synthetic */ CountDownLatch val$latch;
                {
                    this.val$map = map;
                    this.val$latch = countDownLatch;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    CaseInsensitiveMap foo = new CaseInsensitiveMap();
                    foo.put("counter" + count, count);
                    foo.put("foo", 123);
                    foo.put("bar", 456);
                    foo.put("cake", "cheese");
                    Map map = this.val$map;
                    synchronized (map) {
                        this.val$map.putAll(foo);
                    }
                    this.val$latch.countDown();
                }
            });
        }
        CaseInsensitiveMapTest.assertTrue((boolean)latch.await(10L, TimeUnit.SECONDS));
        CaseInsensitiveMapTest.assertEquals((int)1003, (int)map.size());
        CaseInsensitiveMapTest.assertEquals((boolean)true, (boolean)map.containsKey("counter0"));
        CaseInsensitiveMapTest.assertEquals((boolean)true, (boolean)map.containsKey("counter500"));
        CaseInsensitiveMapTest.assertEquals((boolean)true, (boolean)map.containsKey("counter999"));
        CaseInsensitiveMapTest.assertEquals((Object)123, map.get("FOO"));
        CaseInsensitiveMapTest.assertEquals((Object)456, map.get("Bar"));
        CaseInsensitiveMapTest.assertEquals((Object)"cheese", map.get("cAKe"));
        service.shutdownNow();
    }

    public void testCopyMapWithCamelHeadersTest() throws Exception {
        CaseInsensitiveMap map = new CaseInsensitiveMap();
        map.put("CamelA", "A");
        map.put("CamelB", "B");
        map.put("CamelC", "C");
        ArrayList<CaseInsensitiveMap> maps = new ArrayList<CaseInsensitiveMap>();
        for (int i = 0; i < 10000; ++i) {
            CaseInsensitiveMap copy = new CaseInsensitiveMap((Map)map);
            CaseInsensitiveMapTest.assertEquals((int)3, (int)copy.size());
            CaseInsensitiveMapTest.assertEquals((Object)"A", copy.get("CamelA"));
            CaseInsensitiveMapTest.assertEquals((Object)"B", copy.get("CamelB"));
            CaseInsensitiveMapTest.assertEquals((Object)"C", copy.get("CamelC"));
            maps.add(copy);
        }
        CaseInsensitiveMapTest.assertEquals((int)10000, (int)maps.size());
        CaseInsensitiveMapTest.assertEquals((int)3, (int)map.size());
        CaseInsensitiveMapTest.assertEquals((Object)"A", map.get("CamelA"));
        CaseInsensitiveMapTest.assertEquals((Object)"B", map.get("CamelB"));
        CaseInsensitiveMapTest.assertEquals((Object)"C", map.get("CamelC"));
    }
}

