/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.util.CamelContextHelper;

public class CamelContextHelperTest
extends ContextTestSupport {
    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("foo", (Object)new MyFooBean());
        return jndi;
    }

    public void testGetMandatoryEndpoint() {
        MockEndpoint mock = (MockEndpoint)CamelContextHelper.getMandatoryEndpoint((CamelContext)this.context, (String)"mock:foo", MockEndpoint.class);
        CamelContextHelperTest.assertNotNull((Object)mock);
    }

    public void testMandatoryConvertTo() {
        Integer num = (Integer)CamelContextHelper.mandatoryConvertTo((CamelContext)this.context, Integer.class, (Object)"5");
        CamelContextHelperTest.assertEquals((int)5, (int)num);
    }

    public void testMandatoryConvertToNotPossible() {
        try {
            CamelContextHelper.mandatoryConvertTo((CamelContext)this.context, CamelContext.class, (Object)"5");
            CamelContextHelperTest.fail((String)"Should have thrown an exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testLookupBean() {
        Object foo = CamelContextHelper.lookup((CamelContext)this.context, (String)"foo");
        CamelContextHelperTest.assertNotNull((Object)foo);
        CamelContextHelperTest.assertIsInstanceOf(MyFooBean.class, foo);
    }

    public void testLookupBeanAndType() {
        MyFooBean foo = (MyFooBean)CamelContextHelper.lookup((CamelContext)this.context, (String)"foo", MyFooBean.class);
        CamelContextHelperTest.assertNotNull((Object)foo);
    }

    public void testRouteStartupOrder() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:foo").routeId("foo").startupOrder(222).to("mock:foo");
                this.from("direct:bar").routeId("bar").startupOrder(111).to("mock:bar");
            }
        });
        CamelContextHelperTest.assertEquals((int)111, (int)CamelContextHelper.getRouteStartupOrder((CamelContext)this.context, (String)"bar"));
        CamelContextHelperTest.assertEquals((int)222, (int)CamelContextHelper.getRouteStartupOrder((CamelContext)this.context, (String)"foo"));
        CamelContextHelperTest.assertEquals((int)0, (int)CamelContextHelper.getRouteStartupOrder((CamelContext)this.context, (String)"zzz"));
    }

    public static class MyFooBean {
    }
}

