/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import junit.framework.TestCase;
import org.apache.camel.support.XMLTokenExpressionIterator;

public class XMLTokenExpressionIteratorGroupingTest
extends TestCase {
    private static final byte[] TEST_BODY = "<?xml version='1.0' encoding='UTF-8'?><g:A xmlns:g='urn:g'><c:B attr='1' xmlns:c='urn:c'><c:C attr='1'>peach</c:C><c:C attr='2'/><c:C attr='3'>orange</c:C><c:C attr='4'/></c:B><c:B attr='2' xmlns:c='urn:c'><c:C attr='5'>mango</c:C><c:C attr='6'/><c:C attr='7'>pear</c:C><c:C attr='8'/></c:B></g:A>".getBytes();
    private static final String[] RESULTS_WRAPPED_SIZE1 = new String[]{"<?xml version='1.0' encoding='UTF-8'?><g:A xmlns:g='urn:g'><c:B attr='1' xmlns:c='urn:c'><c:C attr='1'>peach</c:C></c:B></g:A>", "<?xml version='1.0' encoding='UTF-8'?><g:A xmlns:g='urn:g'><c:B attr='1' xmlns:c='urn:c'><c:C attr='2'/></c:B></g:A>", "<?xml version='1.0' encoding='UTF-8'?><g:A xmlns:g='urn:g'><c:B attr='1' xmlns:c='urn:c'><c:C attr='3'>orange</c:C></c:B></g:A>", "<?xml version='1.0' encoding='UTF-8'?><g:A xmlns:g='urn:g'><c:B attr='1' xmlns:c='urn:c'><c:C attr='4'/></c:B></g:A>", "<?xml version='1.0' encoding='UTF-8'?><g:A xmlns:g='urn:g'><c:B attr='2' xmlns:c='urn:c'><c:C attr='5'>mango</c:C></c:B></g:A>", "<?xml version='1.0' encoding='UTF-8'?><g:A xmlns:g='urn:g'><c:B attr='2' xmlns:c='urn:c'><c:C attr='6'/></c:B></g:A>", "<?xml version='1.0' encoding='UTF-8'?><g:A xmlns:g='urn:g'><c:B attr='2' xmlns:c='urn:c'><c:C attr='7'>pear</c:C></c:B></g:A>", "<?xml version='1.0' encoding='UTF-8'?><g:A xmlns:g='urn:g'><c:B attr='2' xmlns:c='urn:c'><c:C attr='8'/></c:B></g:A>"};
    private static final String[] RESULTS_WRAPPED_SIZE2 = new String[]{"<?xml version='1.0' encoding='UTF-8'?><g:A xmlns:g='urn:g'><c:B attr='1' xmlns:c='urn:c'><c:C attr='1'>peach</c:C><c:C attr='2'/></c:B></g:A>", "<?xml version='1.0' encoding='UTF-8'?><g:A xmlns:g='urn:g'><c:B attr='1' xmlns:c='urn:c'><c:C attr='3'>orange</c:C><c:C attr='4'/></c:B></g:A>", "<?xml version='1.0' encoding='UTF-8'?><g:A xmlns:g='urn:g'><c:B attr='2' xmlns:c='urn:c'><c:C attr='5'>mango</c:C><c:C attr='6'/></c:B></g:A>", "<?xml version='1.0' encoding='UTF-8'?><g:A xmlns:g='urn:g'><c:B attr='2' xmlns:c='urn:c'><c:C attr='7'>pear</c:C><c:C attr='8'/></c:B></g:A>"};
    private static final String[] RESULTS_WRAPPED_SIZE3L = new String[]{"<?xml version='1.0' encoding='UTF-8'?><g:A xmlns:g='urn:g'><c:B attr='1' xmlns:c='urn:c'><c:C attr='1'>peach</c:C><c:C attr='2'/><c:C attr='3'>orange</c:C></c:B></g:A>", "<?xml version='1.0' encoding='UTF-8'?><g:A xmlns:g='urn:g'><c:B attr='1' xmlns:c='urn:c'><c:C attr='4'/></c:B></g:A>", "<?xml version='1.0' encoding='UTF-8'?><g:A xmlns:g='urn:g'><c:B attr='2' xmlns:c='urn:c'><c:C attr='5'>mango</c:C><c:C attr='6'/><c:C attr='7'>pear</c:C></c:B></g:A>", "<?xml version='1.0' encoding='UTF-8'?><g:A xmlns:g='urn:g'><c:B attr='2' xmlns:c='urn:c'><c:C attr='8'/></c:B></g:A>"};
    private static final String[] RESULTS_WRAPPED_SIZE3U = new String[]{"<?xml version='1.0' encoding='UTF-8'?><g:A xmlns:g='urn:g'><c:B attr='1' xmlns:c='urn:c'><c:C attr='1'>peach</c:C><c:C attr='2'/><c:C attr='3'>orange</c:C></c:B></g:A>", "<?xml version='1.0' encoding='UTF-8'?><g:A xmlns:g='urn:g'><c:B attr='1' xmlns:c='urn:c'><c:C attr='4'/></c:B><c:B attr='2' xmlns:c='urn:c'><c:C attr='5'>mango</c:C><c:C attr='6'/></c:B></g:A>", "<?xml version='1.0' encoding='UTF-8'?><g:A xmlns:g='urn:g'><c:B attr='2' xmlns:c='urn:c'><c:C attr='7'>pear</c:C><c:C attr='8'/></c:B></g:A>"};
    private static final String[] RESULTS_WRAPPED_SIZE4 = new String[]{"<?xml version='1.0' encoding='UTF-8'?><g:A xmlns:g='urn:g'><c:B attr='1' xmlns:c='urn:c'><c:C attr='1'>peach</c:C><c:C attr='2'/><c:C attr='3'>orange</c:C><c:C attr='4'/></c:B></g:A>", "<?xml version='1.0' encoding='UTF-8'?><g:A xmlns:g='urn:g'><c:B attr='2' xmlns:c='urn:c'><c:C attr='5'>mango</c:C><c:C attr='6'/><c:C attr='7'>pear</c:C><c:C attr='8'/></c:B></g:A>"};
    private static final String[] RESULTS_WRAPPED_SIZE5L = RESULTS_WRAPPED_SIZE4;
    private static final String[] RESULTS_WRAPPED_SIZE5U = new String[]{"<?xml version='1.0' encoding='UTF-8'?><g:A xmlns:g='urn:g'><c:B attr='1' xmlns:c='urn:c'><c:C attr='1'>peach</c:C><c:C attr='2'/><c:C attr='3'>orange</c:C><c:C attr='4'/></c:B><c:B attr='2' xmlns:c='urn:c'><c:C attr='5'>mango</c:C></c:B></g:A>", "<?xml version='1.0' encoding='UTF-8'?><g:A xmlns:g='urn:g'><c:B attr='2' xmlns:c='urn:c'><c:C attr='6'/><c:C attr='7'>pear</c:C><c:C attr='8'/></c:B></g:A>"};
    private static final String[] RESULTS_INJECTED_SIZE1 = new String[]{"<c:C attr='1' xmlns:g=\"urn:g\" xmlns:c=\"urn:c\">peach</c:C>", "<c:C attr='2' xmlns:g=\"urn:g\" xmlns:c=\"urn:c\"/>", "<c:C attr='3' xmlns:g=\"urn:g\" xmlns:c=\"urn:c\">orange</c:C>", "<c:C attr='4' xmlns:g=\"urn:g\" xmlns:c=\"urn:c\"/>", "<c:C attr='5' xmlns:g=\"urn:g\" xmlns:c=\"urn:c\">mango</c:C>", "<c:C attr='6' xmlns:g=\"urn:g\" xmlns:c=\"urn:c\"/>", "<c:C attr='7' xmlns:g=\"urn:g\" xmlns:c=\"urn:c\">pear</c:C>", "<c:C attr='8' xmlns:g=\"urn:g\" xmlns:c=\"urn:c\"/>"};
    private static final String[] RESULTS_INJECTED_SIZE2 = new String[]{"<group><c:C attr='1' xmlns:g=\"urn:g\" xmlns:c=\"urn:c\">peach</c:C><c:C attr='2' xmlns:g=\"urn:g\" xmlns:c=\"urn:c\"/></group>", "<group><c:C attr='3' xmlns:g=\"urn:g\" xmlns:c=\"urn:c\">orange</c:C><c:C attr='4' xmlns:g=\"urn:g\" xmlns:c=\"urn:c\"/></group>", "<group><c:C attr='5' xmlns:g=\"urn:g\" xmlns:c=\"urn:c\">mango</c:C><c:C attr='6' xmlns:g=\"urn:g\" xmlns:c=\"urn:c\"/></group>", "<group><c:C attr='7' xmlns:g=\"urn:g\" xmlns:c=\"urn:c\">pear</c:C><c:C attr='8' xmlns:g=\"urn:g\" xmlns:c=\"urn:c\"/></group>"};
    private static final String[] RESULTS_INJECTED_SIZE3 = new String[]{"<group><c:C attr='1' xmlns:g=\"urn:g\" xmlns:c=\"urn:c\">peach</c:C><c:C attr='2' xmlns:g=\"urn:g\" xmlns:c=\"urn:c\"/><c:C attr='3' xmlns:g=\"urn:g\" xmlns:c=\"urn:c\">orange</c:C></group>", "<group><c:C attr='4' xmlns:g=\"urn:g\" xmlns:c=\"urn:c\"/><c:C attr='5' xmlns:g=\"urn:g\" xmlns:c=\"urn:c\">mango</c:C><c:C attr='6' xmlns:g=\"urn:g\" xmlns:c=\"urn:c\"/></group>", "<group><c:C attr='7' xmlns:g=\"urn:g\" xmlns:c=\"urn:c\">pear</c:C><c:C attr='8' xmlns:g=\"urn:g\" xmlns:c=\"urn:c\"/></group>"};
    private static final String[] RESULTS_INJECTED_SIZE4 = new String[]{"<group><c:C attr='1' xmlns:g=\"urn:g\" xmlns:c=\"urn:c\">peach</c:C><c:C attr='2' xmlns:g=\"urn:g\" xmlns:c=\"urn:c\"/><c:C attr='3' xmlns:g=\"urn:g\" xmlns:c=\"urn:c\">orange</c:C><c:C attr='4' xmlns:g=\"urn:g\" xmlns:c=\"urn:c\"/></group>", "<group><c:C attr='5' xmlns:g=\"urn:g\" xmlns:c=\"urn:c\">mango</c:C><c:C attr='6' xmlns:g=\"urn:g\" xmlns:c=\"urn:c\"/><c:C attr='7' xmlns:g=\"urn:g\" xmlns:c=\"urn:c\">pear</c:C><c:C attr='8' xmlns:g=\"urn:g\" xmlns:c=\"urn:c\"/></group>"};
    private static final String[] RESULTS_INJECTED_SIZE5 = new String[]{"<group><c:C attr='1' xmlns:g=\"urn:g\" xmlns:c=\"urn:c\">peach</c:C><c:C attr='2' xmlns:g=\"urn:g\" xmlns:c=\"urn:c\"/><c:C attr='3' xmlns:g=\"urn:g\" xmlns:c=\"urn:c\">orange</c:C><c:C attr='4' xmlns:g=\"urn:g\" xmlns:c=\"urn:c\"/><c:C attr='5' xmlns:g=\"urn:g\" xmlns:c=\"urn:c\">mango</c:C></group>", "<group><c:C attr='6' xmlns:g=\"urn:g\" xmlns:c=\"urn:c\"/><c:C attr='7' xmlns:g=\"urn:g\" xmlns:c=\"urn:c\">pear</c:C><c:C attr='8' xmlns:g=\"urn:g\" xmlns:c=\"urn:c\"/></group>"};
    private Map<String, String> nsmap;

    public void setUp() {
        this.nsmap = new HashMap<String, String>();
        this.nsmap.put("g", "urn:g");
        this.nsmap.put("c", "urn:c");
    }

    public void testExtractWrappedSize1() throws Exception {
        this.invokeAndVerify("//c:C", 'w', 1, new ByteArrayInputStream(TEST_BODY), "utf-8", RESULTS_WRAPPED_SIZE1);
    }

    public void testExtractWrappedSize2() throws Exception {
        this.invokeAndVerify("//c:C", 'w', 2, new ByteArrayInputStream(TEST_BODY), "utf-8", RESULTS_WRAPPED_SIZE2);
    }

    public void testExtractWrappedSize3L() throws Exception {
        this.invokeAndVerify("//c:C", 'w', 3, new ByteArrayInputStream(TEST_BODY), "utf-8", RESULTS_WRAPPED_SIZE3L);
    }

    public void disabledtestExtractWrappedSize3U() throws Exception {
        this.invokeAndVerify("//c:C", 'W', 3, new ByteArrayInputStream(TEST_BODY), "utf-8", RESULTS_WRAPPED_SIZE3U);
    }

    public void testExtractWrappedSize4() throws Exception {
        this.invokeAndVerify("//c:C", 'w', 4, new ByteArrayInputStream(TEST_BODY), "utf-8", RESULTS_WRAPPED_SIZE4);
    }

    public void testExtractWrappedSize5L() throws Exception {
        this.invokeAndVerify("//c:C", 'w', 5, new ByteArrayInputStream(TEST_BODY), "utf-8", RESULTS_WRAPPED_SIZE5L);
    }

    public void disabledtestExtractWrappedSize5U() throws Exception {
        this.invokeAndVerify("//c:C", 'W', 5, new ByteArrayInputStream(TEST_BODY), "utf-8", RESULTS_WRAPPED_SIZE5U);
    }

    public void testExtractInjectedSize1() throws Exception {
        this.invokeAndVerify("//c:C", 'i', 1, new ByteArrayInputStream(TEST_BODY), "utf-8", RESULTS_INJECTED_SIZE1);
    }

    public void testExtractInjectedSize2() throws Exception {
        this.invokeAndVerify("//c:C", 'i', 2, new ByteArrayInputStream(TEST_BODY), "utf-8", RESULTS_INJECTED_SIZE2);
    }

    public void testExtractInjectedSize3() throws Exception {
        this.invokeAndVerify("//c:C", 'i', 3, new ByteArrayInputStream(TEST_BODY), "utf-8", RESULTS_INJECTED_SIZE3);
    }

    public void testExtractInjectedSize4() throws Exception {
        this.invokeAndVerify("//c:C", 'i', 4, new ByteArrayInputStream(TEST_BODY), "utf-8", RESULTS_INJECTED_SIZE4);
    }

    public void testExtractInjectedSize5() throws Exception {
        this.invokeAndVerify("//c:C", 'i', 5, new ByteArrayInputStream(TEST_BODY), "utf-8", RESULTS_INJECTED_SIZE5);
    }

    public void testExtractWrappedLeftOver() throws Exception {
        byte[] data = "<?xml version='1.0' encoding='UTF-8'?><g:A xmlns:g='urn:g'><c:B attr='1' xmlns:c='urn:c'><c:C attr='1'>peach</c:C><c:C attr='2'/><c:C attr='3'>orange</c:C></c:B></g:A>".getBytes();
        String[] results = new String[]{"<?xml version='1.0' encoding='UTF-8'?><g:A xmlns:g='urn:g'><c:B attr='1' xmlns:c='urn:c'><c:C attr='1'>peach</c:C><c:C attr='2'/></c:B></g:A>", "<?xml version='1.0' encoding='UTF-8'?><g:A xmlns:g='urn:g'><c:B attr='1' xmlns:c='urn:c'><c:C attr='3'>orange</c:C></c:B></g:A>"};
        this.invokeAndVerify("//c:C", 'w', 2, new ByteArrayInputStream(data), "utf-8", results);
    }

    private void invokeAndVerify(String path, char mode, int group, InputStream in, String charset, String[] expected) throws Exception {
        XMLTokenExpressionIterator xtei = new XMLTokenExpressionIterator(path, mode);
        xtei.setNamespaces(this.nsmap);
        xtei.setGroup(group);
        Iterator it = xtei.createIterator(in, "utf-8");
        ArrayList<String> results = new ArrayList<String>();
        while (it.hasNext()) {
            results.add((String)it.next());
        }
        ((Closeable)((Object)it)).close();
        XMLTokenExpressionIteratorGroupingTest.assertEquals((String)"token count", (int)expected.length, (int)results.size());
        for (int i = 0; i < expected.length; ++i) {
            XMLTokenExpressionIteratorGroupingTest.assertEquals((String)("mismatch [" + i + "]"), (String)expected[i], (String)((String)results.get(i)));
        }
    }
}

