/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.resequencer;

import junit.framework.TestCase;
import org.apache.camel.processor.resequencer.TestComparator;
import org.apache.camel.processor.resequencer.TestObject;

public class TestComparatorTest
extends TestCase {
    private TestComparator c;
    private TestObject e1;
    private TestObject e2;
    private TestObject e3;

    public void setUp() {
        this.c = new TestComparator();
        this.e1 = new TestObject(3);
        this.e2 = new TestObject(4);
        this.e3 = new TestObject(7);
    }

    public void tearDown() throws Exception {
    }

    public void testPredecessor() {
        TestComparatorTest.assertTrue((boolean)this.c.predecessor(this.e1, this.e2));
        TestComparatorTest.assertFalse((boolean)this.c.predecessor(this.e2, this.e1));
        TestComparatorTest.assertFalse((boolean)this.c.predecessor(this.e1, this.e3));
        TestComparatorTest.assertFalse((boolean)this.c.predecessor(this.e3, this.e1));
        TestComparatorTest.assertFalse((boolean)this.c.predecessor(this.e3, this.e3));
    }

    public void testSuccessor() {
        TestComparatorTest.assertTrue((boolean)this.c.successor(this.e2, this.e1));
        TestComparatorTest.assertFalse((boolean)this.c.successor(this.e1, this.e2));
        TestComparatorTest.assertFalse((boolean)this.c.successor(this.e3, this.e1));
        TestComparatorTest.assertFalse((boolean)this.c.successor(this.e1, this.e3));
        TestComparatorTest.assertFalse((boolean)this.c.successor(this.e3, this.e3));
    }

    public void testCompare() {
        TestComparatorTest.assertTrue((this.c.compare(this.e1, this.e2) < 0 ? 1 : 0) != 0);
        TestComparatorTest.assertTrue((this.c.compare(this.e2, this.e1) > 0 ? 1 : 0) != 0);
        TestComparatorTest.assertTrue((this.c.compare(this.e1, this.e3) < 0 ? 1 : 0) != 0);
        TestComparatorTest.assertTrue((this.c.compare(this.e3, this.e1) > 0 ? 1 : 0) != 0);
        TestComparatorTest.assertTrue((this.c.compare(this.e3, this.e3) == 0 ? 1 : 0) != 0);
    }
}

