/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.onexception;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.TypeConverter;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.support.TypeConverterSupport;
import org.apache.camel.util.ObjectHelper;

public class OnExceptionWrappedExceptionTest
extends ContextTestSupport {
    public void testWrappedException() throws Exception {
        this.getMockEndpoint("mock:error").expectedMessageCount(0);
        this.getMockEndpoint("mock:wrapped").expectedMessageCount(1);
        this.getMockEndpoint("mock:end").expectedMessageCount(0);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                OnExceptionWrappedExceptionTest.this.context.getTypeConverterRegistry().addTypeConverter(LocalDateTime.class, String.class, (TypeConverter)new MyLocalDateTimeConverter());
                this.errorHandler((ErrorHandlerBuilder)this.deadLetterChannel("mock:error"));
                this.onException(IllegalArgumentException.class).handled(true).to("mock:wrapped");
                ((RouteDefinition)this.from("direct:start").convertBodyTo(LocalDateTime.class)).to("mock:end");
            }
        };
    }

    private static class MyLocalDateTimeConverter
    extends TypeConverterSupport {
        private MyLocalDateTimeConverter() {
        }

        public <T> T convertTo(Class<T> type, Exchange exchange, Object value) {
            throw ObjectHelper.wrapRuntimeCamelException((Throwable)new IllegalArgumentException("Bad Data"));
        }
    }

    public static class LocalDateTime {
    }
}

