/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.interceptor;

import java.util.List;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.interceptor.TraceTestProcessor;
import org.apache.camel.processor.interceptor.Tracer;

public abstract class TracingTestBase
extends ContextTestSupport {
    protected List<StringBuilder> tracedMessages;
    private TraceTestProcessor processor = new TraceTestProcessor();

    protected void prepareTestTracerInOnly() {
    }

    protected void prepareTestTracerInOut() {
    }

    protected void prepareTestTracerExceptionInOut() {
    }

    protected void validateTestTracerInOnly() {
        TracingTestBase.assertEquals((int)3, (int)this.tracedMessages.size());
        for (StringBuilder tracedMessage : this.tracedMessages) {
            String message = tracedMessage.toString();
            TracingTestBase.assertTrue((boolean)message.startsWith("Complete:"));
        }
    }

    protected void validateTestTracerInOut() {
        TracingTestBase.assertEquals((int)3, (int)this.tracedMessages.size());
        for (StringBuilder tracedMessage : this.tracedMessages) {
            String message = tracedMessage.toString();
            TracingTestBase.assertTrue((boolean)message.startsWith("In:"));
            TracingTestBase.assertTrue((boolean)message.contains("Out:"));
        }
    }

    protected void validateTestTracerExceptionInOut() {
        TracingTestBase.assertEquals((int)5, (int)this.tracedMessages.size());
        for (StringBuilder tracedMessage : this.tracedMessages) {
            String message = tracedMessage.toString();
            TracingTestBase.assertTrue((boolean)message.startsWith("In:"));
            TracingTestBase.assertTrue((boolean)message.contains("Out:"));
        }
        TracingTestBase.assertTrue((boolean)this.tracedMessages.get(2).toString().contains("Ex:"));
    }

    protected int getMessageCount() {
        return this.tracedMessages.size();
    }

    public void testTracerInOnly() throws Exception {
        MockEndpoint result = this.getMockEndpoint("mock:result");
        ((Tracer)this.context.getDefaultTracer()).setTraceOutExchanges(false);
        result.expectedMessageCount(3);
        this.prepareTestTracerInOnly();
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.template.sendBody("direct:start", (Object)"Bye World");
        this.template.sendBody("direct:start", (Object)"Hello Camel");
        this.assertMockEndpointsSatisfied();
        this.validateTestTracerInOnly();
    }

    public void testTracerInOut() throws Exception {
        MockEndpoint result = this.getMockEndpoint("mock:result");
        ((Tracer)this.context.getDefaultTracer()).setTraceOutExchanges(true);
        result.expectedMessageCount(3);
        this.prepareTestTracerInOut();
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.template.sendBody("direct:start", (Object)"Bye World");
        this.template.sendBody("direct:start", (Object)"Hello Camel");
        this.assertMockEndpointsSatisfied();
        this.validateTestTracerInOut();
    }

    public void testTracerExceptionInOut() throws Exception {
        MockEndpoint result = this.getMockEndpoint("mock:result");
        ((Tracer)this.context.getDefaultTracer()).setTraceOutExchanges(true);
        result.expectedMessageCount(2);
        this.prepareTestTracerExceptionInOut();
        this.template.sendBody("direct:start", (Object)"Hello World");
        try {
            this.template.sendBody("direct:start", (Object)"Kaboom");
            TracingTestBase.fail((String)"Should have thrown exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.template.sendBody("direct:start", (Object)"Hello Camel");
        this.assertMockEndpointsSatisfied();
        this.validateTestTracerExceptionInOut();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                TracingTestBase.this.context.setTracing(Boolean.valueOf(true));
                ((RouteDefinition)this.from("direct:start").tracing().process((Processor)TracingTestBase.this.processor)).to("mock:result");
            }
        };
    }
}

