/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.intercept;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;

public class InterceptFromUriWildcardTest
extends ContextTestSupport {
    public void testNoIntercept() throws Exception {
        this.getMockEndpoint("mock:intercept").expectedMessageCount(0);
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    public void testInterceptFoo() throws Exception {
        this.getMockEndpoint("mock:intercept").expectedMessageCount(1);
        this.getMockEndpoint("mock:intercept").expectedHeaderReceived("CamelInterceptedEndpoint", (Object)"seda://foo");
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("seda:foo", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    public void testInterceptBar() throws Exception {
        this.getMockEndpoint("mock:intercept").expectedMessageCount(1);
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("seda:bar", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.interceptFrom("seda*").to("mock:intercept");
                this.from("direct:start").to("mock:result");
                this.from("seda:bar").to("mock:result");
                this.from("seda:foo").to("mock:result");
            }
        };
    }
}

