/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.enricher;

import java.util.EventObject;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.DefaultManagementStrategy;
import org.apache.camel.management.event.ExchangeSendingEvent;
import org.apache.camel.management.event.ExchangeSentEvent;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.async.MyAsyncComponent;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.spi.ManagementStrategy;
import org.apache.camel.spi.ShutdownStrategy;
import org.apache.camel.support.EventNotifierSupport;

public class EnricherSendEventTest
extends ContextTestSupport {
    private MyEventNotifier en = new MyEventNotifier();

    public void testAsyncEnricher() throws Exception {
        this.template.sendBody("direct:start1", (Object)"test");
        EnricherSendEventTest.assertEquals((String)"Get a wrong sending event number", (int)3, (int)this.en.exchangeSendingEvent.get());
        EnricherSendEventTest.assertEquals((String)"Get a wrong sent event number", (int)3, (int)this.en.exchangeSentEvent.get());
    }

    public void testSyncEnricher() throws Exception {
        this.template.sendBody("direct:start2", (Object)"test");
        EnricherSendEventTest.assertEquals((String)"Get a wrong sending event number", (int)3, (int)this.en.exchangeSendingEvent.get());
        EnricherSendEventTest.assertEquals((String)"Get a wrong sent event number", (int)3, (int)this.en.exchangeSentEvent.get());
    }

    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext camelContext = super.createCamelContext();
        ShutdownStrategy shutdownStrategy = camelContext.getShutdownStrategy();
        camelContext.addComponent("async", (Component)new MyAsyncComponent());
        shutdownStrategy.setTimeout(1000L);
        shutdownStrategy.setTimeUnit(TimeUnit.MILLISECONDS);
        shutdownStrategy.setShutdownNowOnTimeout(true);
        DefaultManagementStrategy managementStrategy = new DefaultManagementStrategy();
        managementStrategy.addEventNotifier((EventNotifier)this.en);
        camelContext.setManagementStrategy((ManagementStrategy)managementStrategy);
        return camelContext;
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start1").enrich("async:out?reply=Reply")).to("mock:result");
                ((RouteDefinition)this.from("direct:start2").enrich("direct:result")).to("mock:result");
                this.from("direct:result").setBody((Expression)this.constant("result"));
            }
        };
    }

    static class MyEventNotifier
    extends EventNotifierSupport {
        AtomicInteger exchangeSendingEvent = new AtomicInteger();
        AtomicInteger exchangeSentEvent = new AtomicInteger();

        MyEventNotifier() {
        }

        public void notify(EventObject event) throws Exception {
            if (event instanceof ExchangeSendingEvent) {
                this.exchangeSendingEvent.incrementAndGet();
            } else if (event instanceof ExchangeSentEvent) {
                this.exchangeSentEvent.incrementAndGet();
            }
        }

        public boolean isEnabled(EventObject event) {
            return true;
        }

        protected void doStart() throws Exception {
        }

        protected void doStop() throws Exception {
        }
    }
}

