/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.async;

import org.apache.camel.Component;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.LoadBalanceDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.async.MyAsyncComponent;

public class AsyncEndpointFailOverLoadBalanceMixedTest
extends ContextTestSupport {
    private static String beforeThreadName;
    private static String afterThreadName;

    public void testAsyncEndpoint() throws Exception {
        this.getMockEndpoint("mock:before").expectedBodiesReceived(new Object[]{"Hello Camel"});
        this.getMockEndpoint("mock:fail").expectedBodiesReceived(new Object[]{"Hello Camel"});
        this.getMockEndpoint("mock:after").expectedBodiesReceived(new Object[]{"Bye World"});
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Bye World"});
        String reply = (String)this.template.requestBody("direct:start", (Object)"Hello Camel", String.class);
        AsyncEndpointFailOverLoadBalanceMixedTest.assertEquals((String)"Bye World", (String)reply);
        this.assertMockEndpointsSatisfied();
        AsyncEndpointFailOverLoadBalanceMixedTest.assertFalse((String)"Should use different threads", (boolean)beforeThreadName.equalsIgnoreCase(afterThreadName));
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                AsyncEndpointFailOverLoadBalanceMixedTest.this.context.addComponent("async", (Component)new MyAsyncComponent());
                ((LoadBalanceDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:start").to("mock:before")).to("log:before")).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        beforeThreadName = Thread.currentThread().getName();
                    }
                })).loadBalance().failover().to(new String[]{"async:bye:camel?failFirstAttempts=5", "direct:fail", "async:bye:moon?failFirstAttempts=5", "async:bye:world"})).end().process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        afterThreadName = Thread.currentThread().getName();
                    }
                }).to("log:after").to("mock:after").to("mock:result");
                ((RouteDefinition)((RouteDefinition)this.from("direct:fail").to("log:fail")).to("mock:fail")).throwException((Exception)new IllegalArgumentException("Damn"));
            }
        };
    }
}

