/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.ArrayList;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;

public class SplitCustomExpressionTest
extends ContextTestSupport {
    public void testSplitCustomExpression() throws Exception {
        this.getMockEndpoint("mock:split").expectedBodiesReceived(new Object[]{"A", "B", "C"});
        this.template.sendBody("direct:start", (Object)"A,B,C");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").split((Expression)new MyCustomExpression()).to("mock:split");
            }
        };
    }

    public static class MyCustomExpression
    implements Expression {
        public <T> T evaluate(Exchange exchange, Class<T> type) {
            String body = (String)exchange.getIn().getBody(String.class);
            String[] parts = body.split(",");
            ArrayList<String> list = new ArrayList<String>();
            for (String part : parts) {
                list.add(part);
            }
            return (T)list.iterator();
        }
    }
}

