/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.List;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.RouteStartupOrder;
import org.apache.camel.support.ServiceSupport;

public class RouteServicesStartupOrderTest
extends ContextTestSupport {
    private static String startOrder = "";
    private MyServiceBean service1 = new MyServiceBean("1");
    private MyServiceBean service2 = new MyServiceBean("2");
    private MyServiceBean service3 = new MyServiceBean("3");
    private MyServiceBean service4 = new MyServiceBean("4");

    public void testRouteServiceStartupOrder() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        DefaultCamelContext dcc = (DefaultCamelContext)this.context;
        List order = dcc.getRouteStartupOrder();
        RouteServicesStartupOrderTest.assertEquals((int)4, (int)order.size());
        RouteServicesStartupOrderTest.assertEquals((String)"seda://foo", (String)((RouteStartupOrder)order.get(0)).getRoute().getEndpoint().getEndpointUri());
        RouteServicesStartupOrderTest.assertEquals((String)"direct://start", (String)((RouteStartupOrder)order.get(1)).getRoute().getEndpoint().getEndpointUri());
        RouteServicesStartupOrderTest.assertEquals((String)"seda://bar", (String)((RouteStartupOrder)order.get(2)).getRoute().getEndpoint().getEndpointUri());
        RouteServicesStartupOrderTest.assertEquals((String)"direct://bar", (String)((RouteStartupOrder)order.get(3)).getRoute().getEndpoint().getEndpointUri());
        RouteServicesStartupOrderTest.assertEquals((String)"2143", (String)startOrder);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").startupOrder(2).process((Processor)RouteServicesStartupOrderTest.this.service1)).to("seda:foo");
                ((RouteDefinition)this.from("seda:foo").startupOrder(1).process((Processor)RouteServicesStartupOrderTest.this.service2)).to("mock:result");
                ((RouteDefinition)this.from("direct:bar").startupOrder(9).process((Processor)RouteServicesStartupOrderTest.this.service3)).to("seda:bar");
                ((RouteDefinition)this.from("seda:bar").startupOrder(5).process((Processor)RouteServicesStartupOrderTest.this.service4)).to("mock:other");
            }
        };
    }

    public class MyServiceBean
    extends ServiceSupport
    implements Processor {
        private String name;
        private boolean started;

        public MyServiceBean(String name) {
            this.name = name;
        }

        protected void doStart() throws Exception {
            startOrder = startOrder + this.name;
            this.started = true;
        }

        protected void doStop() throws Exception {
            this.started = false;
        }

        public boolean isStarted() {
            return this.started;
        }

        public String getName() {
            return this.name;
        }

        public void setStarted(boolean started) {
            this.started = started;
        }

        public void process(Exchange exchange) throws Exception {
        }
    }
}

