/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;

public class RouteFormattedUriTest
extends ContextTestSupport {
    private String path = "target/toformat";
    private String name = "hello.txt";
    private String pattern = ".*txt$";
    private String result = "result";

    @Override
    protected void setUp() throws Exception {
        RouteFormattedUriTest.deleteDirectory("target/toformat");
        super.setUp();
    }

    public void testFormattedUri() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:" + this.result);
        mock.expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").toF("file://%s?fileName=%s", new Object[]{RouteFormattedUriTest.this.path, RouteFormattedUriTest.this.name});
                this.fromF("file://%s?include=%s", new Object[]{RouteFormattedUriTest.this.path, RouteFormattedUriTest.this.pattern}).toF("mock:%s", new Object[]{RouteFormattedUriTest.this.result});
            }
        };
    }
}

