/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import junit.framework.TestCase;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.RecipientList;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.aggregate.AggregationStrategy;

public class RecipientListFineGrainedErrorHandlingTest
extends ContextTestSupport {
    private static int counter;
    private static int tries;

    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("fail", (Object)new MyFailBean());
        return jndi;
    }

    public void testRecipientListOk() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.onException(Exception.class).maximumRedeliveries(2);
                ((RouteDefinition)this.from("direct:start").to("mock:a")).recipientList((Expression)this.header("foo")).stopOnException();
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:a").expectedMessageCount(1);
        this.getMockEndpoint("mock:foo").expectedMessageCount(1);
        this.getMockEndpoint("mock:bar").expectedMessageCount(1);
        this.getMockEndpoint("mock:baz").expectedMessageCount(1);
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "foo", (Object)"mock:foo,mock:bar,mock:baz");
        this.assertMockEndpointsSatisfied();
    }

    public void testRecipientListErrorAggregate() throws Exception {
        counter = 0;
        tries = 0;
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").onException(Exception.class).maximumRedeliveries(3).end().to("mock:a").recipientList((Expression)this.header("foo")).aggregationStrategy((AggregationStrategy)new MyAggregationStrategy()).parallelProcessing();
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:a").expectedMessageCount(1);
        this.getMockEndpoint("mock:foo").expectedMinimumMessageCount(0);
        this.getMockEndpoint("mock:bar").expectedMinimumMessageCount(0);
        this.getMockEndpoint("mock:baz").expectedMinimumMessageCount(0);
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "foo", (Object)"mock:foo,mock:bar,bean:fail,mock:baz");
        this.assertMockEndpointsSatisfied();
        RecipientListFineGrainedErrorHandlingTest.assertEquals((int)4, (int)counter);
        RecipientListFineGrainedErrorHandlingTest.assertEquals((int)3, (int)tries);
    }

    public void testRecipientListError() throws Exception {
        counter = 0;
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.onException(Exception.class).maximumRedeliveries(2);
                ((RouteDefinition)this.from("direct:start").to("mock:a")).recipientList((Expression)this.header("foo")).stopOnException();
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:a").expectedMessageCount(1);
        this.getMockEndpoint("mock:foo").expectedMessageCount(1);
        this.getMockEndpoint("mock:bar").expectedMessageCount(1);
        this.getMockEndpoint("mock:baz").expectedMessageCount(0);
        try {
            this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "foo", (Object)"mock:foo,mock:bar,bean:fail,mock:baz");
            RecipientListFineGrainedErrorHandlingTest.fail((String)"Should throw exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.assertMockEndpointsSatisfied();
        RecipientListFineGrainedErrorHandlingTest.assertEquals((int)3, (int)counter);
    }

    public void testRecipientListAsBeanError() throws Exception {
        counter = 0;
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                RecipientListFineGrainedErrorHandlingTest.this.context.setTracing(Boolean.valueOf(true));
                this.onException(Exception.class).maximumRedeliveries(2);
                ((RouteDefinition)this.from("direct:start").to("mock:a")).bean(MyRecipientBean.class);
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:a").expectedMessageCount(1);
        this.getMockEndpoint("mock:foo").expectedMessageCount(1);
        this.getMockEndpoint("mock:bar").expectedMessageCount(1);
        this.getMockEndpoint("mock:baz").expectedMessageCount(0);
        try {
            this.template.sendBody("direct:start", (Object)"Hello World");
            RecipientListFineGrainedErrorHandlingTest.fail((String)"Should throw exception");
        }
        catch (CamelExecutionException e) {
            RecipientListFineGrainedErrorHandlingTest.assertIsInstanceOf(CamelExchangeException.class, e.getCause());
            RecipientListFineGrainedErrorHandlingTest.assertIsInstanceOf(IllegalArgumentException.class, e.getCause().getCause());
            RecipientListFineGrainedErrorHandlingTest.assertEquals((String)"Damn", (String)e.getCause().getCause().getMessage());
        }
        this.assertMockEndpointsSatisfied();
        RecipientListFineGrainedErrorHandlingTest.assertEquals((int)3, (int)counter);
    }

    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    public static class MyFailBean {
        public String doSomething(Exchange exchange) throws Exception {
            counter++;
            TestCase.assertEquals((String)"bean://fail", (String)((String)exchange.getProperty("CamelToEndpoint", String.class)));
            throw new IllegalArgumentException("Damn");
        }
    }

    public static class MyRecipientBean {
        @RecipientList(stopOnException=true)
        public String sendSomewhere(Exchange exchange) {
            return "mock:foo,mock:bar,bean:fail,mock:baz";
        }
    }

    public static class MyAggregationStrategy
    implements AggregationStrategy {
        public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
            Boolean redelivered = (Boolean)newExchange.getIn().getHeader("CamelRedelivered", Boolean.class);
            if (redelivered != null && redelivered.booleanValue()) {
                tries = (Integer)newExchange.getIn().getHeader("CamelRedeliveryCounter", Integer.class);
                TestCase.assertEquals((String)"bean://fail", (String)((String)newExchange.getProperty("CamelFailureEndpoint", String.class)));
            }
            return newExchange;
        }
    }
}

