/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.support.SynchronizationAdapter;

public class OnCompletionShouldBeLastTest
extends ContextTestSupport {
    public void testOnCompletionShouldBeLast() throws Exception {
        this.getMockEndpoint("mock:sync").expectedBodiesReceived(new Object[]{"C", "B", "A", "Hello World"});
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.onCompletion().to("mock:sync");
                ((RouteDefinition)this.from("direct:start").process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        exchange.addOnCompletion((Synchronization)new SynchronizationAdapter(){

                            public void onDone(Exchange exchange) {
                                OnCompletionShouldBeLastTest.this.template.sendBody("mock:sync", (Object)"A");
                            }

                            public String toString() {
                                return "A";
                            }
                        });
                        exchange.addOnCompletion((Synchronization)new SynchronizationAdapter(){

                            public void onDone(Exchange exchange) {
                                OnCompletionShouldBeLastTest.this.template.sendBody("mock:sync", (Object)"B");
                            }

                            public String toString() {
                                return "B";
                            }
                        });
                        exchange.addOnCompletion((Synchronization)new SynchronizationAdapter(){

                            public void onDone(Exchange exchange) {
                                OnCompletionShouldBeLastTest.this.template.sendBody("mock:sync", (Object)"C");
                            }

                            public String toString() {
                                return "C";
                            }
                        });
                    }
                })).to("mock:result");
            }
        };
    }
}

