/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.MulticastDefinition;
import org.apache.camel.model.RouteDefinition;

public class MulticastParallelStopOnExceptionTest
extends ContextTestSupport {
    private ExecutorService service;

    @Override
    protected void setUp() throws Exception {
        this.service = Executors.newFixedThreadPool(2);
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        this.service.shutdownNow();
    }

    public void testMulticastParallelStopOnExceptionOk() throws Exception {
        this.getMockEndpoint("mock:foo").expectedBodiesReceived(new Object[]{"Hello"});
        this.getMockEndpoint("mock:bar").expectedBodiesReceived(new Object[]{"Hello"});
        this.getMockEndpoint("mock:baz").expectedBodiesReceived(new Object[]{"Hello"});
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello"});
        this.template.sendBody("direct:start", (Object)"Hello");
        this.assertMockEndpointsSatisfied();
    }

    public void testMulticastParalllelStopOnExceptionStop() throws Exception {
        this.getMockEndpoint("mock:foo").expectedMinimumMessageCount(0);
        this.getMockEndpoint("mock:bar").expectedMinimumMessageCount(0);
        this.getMockEndpoint("mock:baz").expectedMinimumMessageCount(0);
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        try {
            this.template.sendBody("direct:start", (Object)"Kaboom");
            MulticastParallelStopOnExceptionTest.fail((String)"Should thrown an exception");
        }
        catch (CamelExecutionException e) {
            CamelExchangeException cause = MulticastParallelStopOnExceptionTest.assertIsInstanceOf(CamelExchangeException.class, e.getCause());
            MulticastParallelStopOnExceptionTest.assertTrue((boolean)cause.getMessage().startsWith("Parallel processing failed for number "));
            MulticastParallelStopOnExceptionTest.assertTrue((boolean)cause.getMessage().contains("[Message: Kaboom]"));
            MulticastParallelStopOnExceptionTest.assertEquals((String)"Forced", (String)cause.getCause().getMessage());
        }
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((MulticastDefinition)this.from("direct:start").multicast().parallelProcessing().stopOnException().executorService(MulticastParallelStopOnExceptionTest.this.service).to(new String[]{"direct:foo", "direct:bar", "direct:baz"})).end().to("mock:result");
                this.from("direct:foo").delay(1000L).to("mock:foo");
                ((RouteDefinition)this.from("direct:bar").process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        String body = (String)exchange.getIn().getBody(String.class);
                        if ("Kaboom".equals(body)) {
                            throw new IllegalArgumentException("Forced");
                        }
                    }
                })).to("mock:bar");
                this.from("direct:baz").delay(1000L).to("mock:baz");
            }
        };
    }
}

