/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import javax.naming.Context;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Header;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.FilterDefinition;

public class MethodFilterTest
extends ContextTestSupport {
    public void testSendMatchingMessage() throws Exception {
        String body = "<person name='James' city='London'/>";
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{body});
        this.template.sendBodyAndHeader("direct:start", ExchangePattern.InOut, (Object)body, "foo", (Object)"London");
        this.assertMockEndpointsSatisfied();
    }

    public void testSendNotMatchingMessage() throws Exception {
        String body = "<person name='Hiram' city='Tampa'/>";
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        this.template.sendBodyAndHeader("direct:start", ExchangePattern.InOut, (Object)body, "foo", (Object)"Tampa");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((FilterDefinition)this.from("direct:start").filter().method("myBean", "matches")).to("mock:result");
            }
        };
    }

    @Override
    protected Context createJndiContext() throws Exception {
        Context context = super.createJndiContext();
        context.bind("myBean", (Object)new MyBean());
        return context;
    }

    public static class MyBean {
        public boolean matches(@Header(value="foo") String location) {
            return "London".equals(location);
        }
    }
}

