/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.CamelContext;
import org.apache.camel.Consumer;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultConsumer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.model.RouteDefinition;

public class EndpointMustBeStartedBeforeSendProcessorTest
extends ContextTestSupport {
    private MyEndpoint myendpoint;
    private volatile String order = "";

    public void testEndpointMustBeStartedBeforeProducer() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                EndpointMustBeStartedBeforeSendProcessorTest.this.myendpoint = new MyEndpoint("myendpoint", (CamelContext)EndpointMustBeStartedBeforeSendProcessorTest.this.context);
                this.from("direct:start").to((Endpoint)EndpointMustBeStartedBeforeSendProcessorTest.this.myendpoint);
            }
        });
        this.context.start();
        EndpointMustBeStartedBeforeSendProcessorTest.assertEquals((String)"EndpointProducer", (String)this.order);
    }

    public void testEndpointMustBeStartedBeforeConsumer() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                EndpointMustBeStartedBeforeSendProcessorTest.this.myendpoint = new MyEndpoint("myendpoint", (CamelContext)EndpointMustBeStartedBeforeSendProcessorTest.this.context);
                this.from((Endpoint)EndpointMustBeStartedBeforeSendProcessorTest.this.myendpoint).to("mock:result");
            }
        });
        this.context.start();
        EndpointMustBeStartedBeforeSendProcessorTest.assertEquals((String)"EndpointConsumer", (String)this.order);
    }

    public void testEndpointMustBeStartedBeforeConsumerAndProducer() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                EndpointMustBeStartedBeforeSendProcessorTest.this.myendpoint = new MyEndpoint("myendpoint", (CamelContext)EndpointMustBeStartedBeforeSendProcessorTest.this.context);
                ((RouteDefinition)this.from((Endpoint)EndpointMustBeStartedBeforeSendProcessorTest.this.myendpoint).to("mock:result")).to((Endpoint)EndpointMustBeStartedBeforeSendProcessorTest.this.myendpoint);
            }
        });
        this.context.start();
        EndpointMustBeStartedBeforeSendProcessorTest.assertEquals((String)"EndpointProducerConsumer", (String)this.order);
    }

    public void testEndpointStartedOnceAndOnlyStoppedOnShutdown() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                EndpointMustBeStartedBeforeSendProcessorTest.this.myendpoint = new MyEndpoint("myendpoint", (CamelContext)EndpointMustBeStartedBeforeSendProcessorTest.this.context);
                ((RouteDefinition)this.from((Endpoint)EndpointMustBeStartedBeforeSendProcessorTest.this.myendpoint).routeId("foo").to("mock:result")).to((Endpoint)EndpointMustBeStartedBeforeSendProcessorTest.this.myendpoint);
            }
        });
        this.context.start();
        EndpointMustBeStartedBeforeSendProcessorTest.assertEquals((String)"EndpointProducerConsumer", (String)this.order);
        this.order = "";
        this.context.stopRoute("foo");
        EndpointMustBeStartedBeforeSendProcessorTest.assertEquals((String)"StopConsumerStopProducer", (String)this.order);
        this.order = "";
        this.context.startRoute("foo");
        EndpointMustBeStartedBeforeSendProcessorTest.assertEquals((String)"ProducerConsumer", (String)this.order);
        this.order = "";
        this.context.stop();
        EndpointMustBeStartedBeforeSendProcessorTest.assertEquals((String)"StopConsumerStopProducerStopEndpoint", (String)this.order);
    }

    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    private class MyConsumer
    extends DefaultConsumer {
        public MyConsumer(Endpoint endpoint, Processor processor) {
            super(endpoint, processor);
        }

        protected void doStart() throws Exception {
            EndpointMustBeStartedBeforeSendProcessorTest.this.order = EndpointMustBeStartedBeforeSendProcessorTest.this.order + "Consumer";
        }

        protected void doStop() throws Exception {
            EndpointMustBeStartedBeforeSendProcessorTest.this.order = EndpointMustBeStartedBeforeSendProcessorTest.this.order + "StopConsumer";
        }
    }

    private class MyProducer
    extends DefaultProducer {
        public MyProducer(Endpoint endpoint) {
            super(endpoint);
        }

        public void process(Exchange exchange) throws Exception {
        }

        protected void doStart() throws Exception {
            EndpointMustBeStartedBeforeSendProcessorTest.this.order = EndpointMustBeStartedBeforeSendProcessorTest.this.order + "Producer";
        }

        protected void doStop() throws Exception {
            EndpointMustBeStartedBeforeSendProcessorTest.this.order = EndpointMustBeStartedBeforeSendProcessorTest.this.order + "StopProducer";
        }
    }

    private final class MyEndpoint
    extends DefaultEndpoint {
        private MyEndpoint(String endpointUri, CamelContext camelContext) {
            this.setCamelContext(camelContext);
            this.setEndpointUri(endpointUri);
        }

        public Producer createProducer() throws Exception {
            return new MyProducer((Endpoint)this);
        }

        public Consumer createConsumer(Processor processor) throws Exception {
            return new MyConsumer((Endpoint)this, null);
        }

        public boolean isSingleton() {
            return true;
        }

        public void doStart() throws Exception {
            EndpointMustBeStartedBeforeSendProcessorTest.this.order = EndpointMustBeStartedBeforeSendProcessorTest.this.order + "Endpoint";
        }

        protected void doStop() throws Exception {
            EndpointMustBeStartedBeforeSendProcessorTest.this.order = EndpointMustBeStartedBeforeSendProcessorTest.this.order + "StopEndpoint";
        }
    }
}

