/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.interceptor.TraceEventMessage;
import org.apache.camel.processor.interceptor.Tracer;
import org.apache.camel.spi.InterceptStrategy;

public class DefaultErrorHandlerOnExceptionTraceTest
extends ContextTestSupport {
    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("myProcessor", (Object)new MyProcessor());
        return jndi;
    }

    public void testOk() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Bye World"});
        this.getMockEndpoint("mock:trace").expectedMessageCount(2);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        TraceEventMessage msg1 = (TraceEventMessage)((Exchange)this.getMockEndpoint("mock:trace").getReceivedExchanges().get(0)).getIn().getBody(TraceEventMessage.class);
        TraceEventMessage msg2 = (TraceEventMessage)((Exchange)this.getMockEndpoint("mock:trace").getReceivedExchanges().get(1)).getIn().getBody(TraceEventMessage.class);
        DefaultErrorHandlerOnExceptionTraceTest.assertEquals((String)"direct://start", (String)msg1.getFromEndpointUri());
        DefaultErrorHandlerOnExceptionTraceTest.assertEquals((String)"ref:myProcessor", (String)msg1.getToNode());
        DefaultErrorHandlerOnExceptionTraceTest.assertEquals((String)"ref:myProcessor", (String)msg2.getPreviousNode());
        DefaultErrorHandlerOnExceptionTraceTest.assertEquals((String)"mock://result", (String)msg2.getToNode());
    }

    public void testWithError() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:boom");
        mock.expectedMessageCount(1);
        this.getMockEndpoint("mock:trace").expectedMessageCount(4);
        this.template.sendBody("direct:start", (Object)"Kabom");
        this.assertMockEndpointsSatisfied();
        TraceEventMessage msg1 = (TraceEventMessage)((Exchange)this.getMockEndpoint("mock:trace").getReceivedExchanges().get(0)).getIn().getBody(TraceEventMessage.class);
        TraceEventMessage msg2 = (TraceEventMessage)((Exchange)this.getMockEndpoint("mock:trace").getReceivedExchanges().get(1)).getIn().getBody(TraceEventMessage.class);
        TraceEventMessage msg3 = (TraceEventMessage)((Exchange)this.getMockEndpoint("mock:trace").getReceivedExchanges().get(2)).getIn().getBody(TraceEventMessage.class);
        TraceEventMessage msg4 = (TraceEventMessage)((Exchange)this.getMockEndpoint("mock:trace").getReceivedExchanges().get(3)).getIn().getBody(TraceEventMessage.class);
        DefaultErrorHandlerOnExceptionTraceTest.assertEquals((String)"direct://start", (String)msg1.getFromEndpointUri());
        DefaultErrorHandlerOnExceptionTraceTest.assertEquals((String)"ref:myProcessor", (String)msg1.getToNode());
        DefaultErrorHandlerOnExceptionTraceTest.assertEquals((String)"ref:myProcessor", (String)msg2.getPreviousNode());
        DefaultErrorHandlerOnExceptionTraceTest.assertEquals((String)"OnException[IllegalArgumentException]", (String)msg2.getToNode());
        DefaultErrorHandlerOnExceptionTraceTest.assertEquals((String)"OnException[IllegalArgumentException]", (String)msg3.getPreviousNode());
        DefaultErrorHandlerOnExceptionTraceTest.assertEquals((String)"log://boom", (String)msg3.getToNode());
        DefaultErrorHandlerOnExceptionTraceTest.assertEquals((String)"log://boom", (String)msg4.getPreviousNode());
        DefaultErrorHandlerOnExceptionTraceTest.assertEquals((String)"mock://boom", (String)msg4.getToNode());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                Tracer tracer = new Tracer();
                tracer.setDestinationUri("mock:trace");
                DefaultErrorHandlerOnExceptionTraceTest.this.context.addInterceptStrategy((InterceptStrategy)tracer);
                ((OnExceptionDefinition)this.onException(IllegalArgumentException.class).handled(true).to("log:boom")).to("mock:boom");
                ((RouteDefinition)this.from("direct:start").process("myProcessor")).to("mock:result");
            }
        };
    }

    public static class MyProcessor
    implements Processor {
        public void process(Exchange exchange) throws Exception {
            String body = (String)exchange.getIn().getBody(String.class);
            if ("Kabom".equals(body)) {
                throw new IllegalArgumentException("Boom");
            }
            exchange.getIn().setBody((Object)"Bye World");
        }
    }
}

