/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.Component;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.DefaultConsumerBridgeErrorHandlerTest;

public class DefaultConsumerBridgeErrorHandlerRedeliveryTest
extends DefaultConsumerBridgeErrorHandlerTest {
    protected final AtomicInteger redeliverCounter = new AtomicInteger();

    @Override
    public void testDefaultConsumerBridgeErrorHandler() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello World", "Hello World"});
        this.getMockEndpoint("mock:dead").expectedBodiesReceived(new Object[]{"Cannot process"});
        this.latch.countDown();
        this.assertMockEndpointsSatisfied();
        DefaultConsumerBridgeErrorHandlerRedeliveryTest.assertEquals((int)0, (int)this.redeliverCounter.get());
        Exception cause = (Exception)((Exchange)this.getMockEndpoint("mock:dead").getReceivedExchanges().get(0)).getProperty("CamelExceptionCaught", Exception.class);
        DefaultConsumerBridgeErrorHandlerRedeliveryTest.assertNotNull((Object)cause);
        DefaultConsumerBridgeErrorHandlerRedeliveryTest.assertEquals((String)"Simulated", (String)cause.getMessage());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.getContext().addComponent("my", (Component)new DefaultConsumerBridgeErrorHandlerTest.MyComponent());
                this.onException(Exception.class).maximumRedeliveries(3).onRedelivery(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        DefaultConsumerBridgeErrorHandlerRedeliveryTest.this.redeliverCounter.incrementAndGet();
                    }
                }).handled(true).to("mock:dead");
                ((RouteDefinition)this.from("my:foo?consumer.bridgeErrorHandler=true").to("log:foo")).to("mock:result");
            }
        };
    }
}

