/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import junit.framework.TestCase;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.builder.DefaultErrorHandlerBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;

public class DeadLetterChannelUseOriginalInBodyTest
extends ContextTestSupport {
    public void testUseOriginalnBody() throws Exception {
        MockEndpoint dead = this.getMockEndpoint("mock:a");
        dead.expectedBodiesReceived(new Object[]{"Hello"});
        this.template.sendBody("direct:a", (Object)"Hello");
        this.assertMockEndpointsSatisfied();
    }

    public void testDoNotUseOriginalInBody() throws Exception {
        MockEndpoint dead = this.getMockEndpoint("mock:b");
        dead.expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("direct:b", (Object)"Hello");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                DefaultErrorHandlerBuilder a = this.deadLetterChannel("mock:a").maximumRedeliveries(2).redeliveryDelay(0L).logStackTrace(false).useOriginalMessage();
                DefaultErrorHandlerBuilder b = this.deadLetterChannel("mock:b").maximumRedeliveries(2).redeliveryDelay(0L).logStackTrace(false);
                ((RouteDefinition)this.from("direct:a").errorHandler((ErrorHandlerFactory)a).setBody((Expression)this.body().append((Object)" World"))).process((Processor)new MyThrowProcessor());
                ((RouteDefinition)this.from("direct:b").errorHandler((ErrorHandlerFactory)b).setBody((Expression)this.body().append((Object)" World"))).process((Processor)new MyThrowProcessor());
            }
        };
    }

    public static class MyThrowProcessor
    implements Processor {
        public void process(Exchange exchange) throws Exception {
            TestCase.assertEquals((String)"Hello World", (String)((String)exchange.getIn().getBody(String.class)));
            throw new IllegalArgumentException("Forced");
        }
    }
}

