/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.ArrayList;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.RouteDefinition;

public class RemoveRouteDefinitionTest
extends ManagementTestSupport {
    public void testShutdownRoute() throws Exception {
        if (RemoveRouteDefinitionTest.isPlatform("aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        Set<ObjectName> set = mbeanServer.queryNames(new ObjectName("*:type=routes,*"), null);
        RemoveRouteDefinitionTest.assertEquals((int)1, (int)set.size());
        ObjectName on = set.iterator().next();
        boolean registered = mbeanServer.isRegistered(on);
        RemoveRouteDefinitionTest.assertEquals((String)"Should be registered", (boolean)true, (boolean)registered);
        RouteDefinition definition = this.context.getRouteDefinition("route1");
        ArrayList<RouteDefinition> routeDefinitions = new ArrayList<RouteDefinition>();
        routeDefinitions.add(definition);
        this.context.shutdownRoute("route1");
        set = mbeanServer.queryNames(new ObjectName("*:type=routes,*"), null);
        RemoveRouteDefinitionTest.assertEquals((int)0, (int)set.size());
    }

    public void testStopAndRemoveRoute() throws Exception {
        if (RemoveRouteDefinitionTest.isPlatform("aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        Set<ObjectName> set = mbeanServer.queryNames(new ObjectName("*:type=routes,*"), null);
        RemoveRouteDefinitionTest.assertEquals((int)1, (int)set.size());
        ObjectName on = set.iterator().next();
        boolean registered = mbeanServer.isRegistered(on);
        RemoveRouteDefinitionTest.assertEquals((String)"Should be registered", (boolean)true, (boolean)registered);
        RouteDefinition definition = this.context.getRouteDefinition("route1");
        ArrayList<RouteDefinition> routeDefinitions = new ArrayList<RouteDefinition>();
        routeDefinitions.add(definition);
        this.context.stopRoute("route1");
        this.context.removeRoute("route1");
        set = mbeanServer.queryNames(new ObjectName("*:type=routes,*"), null);
        RemoveRouteDefinitionTest.assertEquals((int)0, (int)set.size());
    }

    public void testStopRoute() throws Exception {
        if (RemoveRouteDefinitionTest.isPlatform("aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        Set<ObjectName> set = mbeanServer.queryNames(new ObjectName("*:type=routes,*"), null);
        RemoveRouteDefinitionTest.assertEquals((int)1, (int)set.size());
        ObjectName on = set.iterator().next();
        boolean registered = mbeanServer.isRegistered(on);
        RemoveRouteDefinitionTest.assertEquals((String)"Should be registered", (boolean)true, (boolean)registered);
        RouteDefinition definition = this.context.getRouteDefinition("route1");
        ArrayList<RouteDefinition> routeDefinitions = new ArrayList<RouteDefinition>();
        routeDefinitions.add(definition);
        this.context.stopRoute("route1");
        set = mbeanServer.queryNames(new ObjectName("*:type=routes,*"), null);
        RemoveRouteDefinitionTest.assertEquals((int)1, (int)set.size());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").routeId("route1").to("log:foo")).to("mock:result");
            }
        };
    }
}

