/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.openmbean.TabularData;
import org.apache.camel.Expression;
import org.apache.camel.ServiceStatus;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.LoadBalanceDefinition;

public class ManagedStickyLoadBalancerTest
extends ManagementTestSupport {
    public void testManageStickyLoadBalancer() throws Exception {
        if (ManagedStickyLoadBalancerTest.isPlatform("aix")) {
            return;
        }
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "num", (Object)"123");
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ObjectName.getInstance("org.apache.camel:context=camel-1,type=processors,name=\"mysend\"");
        String routeId = (String)mbeanServer.getAttribute(on, "RouteId");
        ManagedStickyLoadBalancerTest.assertEquals((String)"route1", (String)routeId);
        String camelId = (String)mbeanServer.getAttribute(on, "CamelId");
        ManagedStickyLoadBalancerTest.assertEquals((String)"camel-1", (String)camelId);
        String state = (String)mbeanServer.getAttribute(on, "State");
        ManagedStickyLoadBalancerTest.assertEquals((String)ServiceStatus.Started.name(), (String)state);
        Integer size = (Integer)mbeanServer.getAttribute(on, "Size");
        ManagedStickyLoadBalancerTest.assertEquals((int)2, (int)size);
        String lan = (String)mbeanServer.getAttribute(on, "ExpressionLanguage");
        ManagedStickyLoadBalancerTest.assertEquals((String)"header", (String)lan);
        String uri = (String)mbeanServer.getAttribute(on, "Expression");
        ManagedStickyLoadBalancerTest.assertEquals((String)"num", (String)uri);
        String last = (String)mbeanServer.getAttribute(on, "LastChosenProcessorId");
        ManagedStickyLoadBalancerTest.assertTrue(("foo".equals(last) || "bar".equals(last) ? 1 : 0) != 0);
        this.template.sendBodyAndHeader("direct:start", (Object)"Bye World", "num", (Object)"123");
        String last2 = (String)mbeanServer.getAttribute(on, "LastChosenProcessorId");
        ManagedStickyLoadBalancerTest.assertEquals((String)"Should be sticky", (String)last, (String)last2);
        TabularData data = (TabularData)mbeanServer.invoke(on, "explain", new Object[]{false}, new String[]{"boolean"});
        ManagedStickyLoadBalancerTest.assertNotNull((Object)data);
        ManagedStickyLoadBalancerTest.assertEquals((int)2, (int)data.size());
        data = (TabularData)mbeanServer.invoke(on, "explain", new Object[]{true}, new String[]{"boolean"});
        ManagedStickyLoadBalancerTest.assertNotNull((Object)data);
        ManagedStickyLoadBalancerTest.assertEquals((int)5, (int)data.size());
        String json = (String)mbeanServer.invoke(on, "informationJson", null, null);
        ManagedStickyLoadBalancerTest.assertNotNull((Object)json);
        ManagedStickyLoadBalancerTest.assertTrue((boolean)json.contains("\"description\": \"Balances message processing among a number of nodes"));
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((LoadBalanceDefinition)((LoadBalanceDefinition)((LoadBalanceDefinition)((LoadBalanceDefinition)this.from("direct:start").loadBalance().sticky((Expression)this.header("num")).id("mysend")).to("mock:foo")).id("foo")).to("mock:bar")).id("bar");
            }
        };
    }
}

