/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.ServiceStatus;
import org.apache.camel.api.management.mbean.ManagedSuspendableRouteMBean;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.management.ManagementTestSupport;

public class ManagedRouteSuspendAndResumeTest
extends ManagementTestSupport {
    @Override
    protected void setUp() throws Exception {
        ManagedRouteSuspendAndResumeTest.deleteDirectory("target/managed");
        super.setUp();
    }

    public void testSuspendAndResume() throws Exception {
        if (ManagedRouteSuspendAndResumeTest.isPlatform("aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ManagedRouteSuspendAndResumeTest.getRouteObjectName(mbeanServer);
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBodyAndHeader("file://target/managed", (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        this.assertMockEndpointsSatisfied();
        String state = (String)mbeanServer.getAttribute(on, "State");
        ManagedRouteSuspendAndResumeTest.assertEquals((String)"Should be started", (String)ServiceStatus.Started.name(), (String)state);
        mbeanServer.invoke(on, "suspend", null, null);
        state = (String)mbeanServer.getAttribute(on, "State");
        ManagedRouteSuspendAndResumeTest.assertEquals((String)"Should be suspended", (String)ServiceStatus.Suspended.name(), (String)state);
        mock.reset();
        mock.expectedBodiesReceived(new Object[]{"Bye World"});
        mock.setResultWaitTime(3000L);
        this.template.sendBodyAndHeader("file://target/managed", (Object)"Bye World", "CamelFileName", (Object)"bye.txt");
        mock.assertIsNotSatisfied();
        mock.reset();
        mock.expectedBodiesReceived(new Object[]{"Bye World"});
        mbeanServer.invoke(on, "resume", null, null);
        state = (String)mbeanServer.getAttribute(on, "State");
        ManagedRouteSuspendAndResumeTest.assertEquals((String)"Should be started", (String)ServiceStatus.Started.name(), (String)state);
        mock.assertIsSatisfied();
        ManagedSuspendableRouteMBean route = (ManagedSuspendableRouteMBean)this.context.getManagedRoute("foo", ManagedSuspendableRouteMBean.class);
        ManagedRouteSuspendAndResumeTest.assertNotNull((Object)route);
        ManagedRouteSuspendAndResumeTest.assertEquals((long)2L, (long)route.getExchangesCompleted());
    }

    static ObjectName getRouteObjectName(MBeanServer mbeanServer) throws Exception {
        Set<ObjectName> set = mbeanServer.queryNames(new ObjectName("*:type=routes,*"), null);
        ManagedRouteSuspendAndResumeTest.assertEquals((int)1, (int)set.size());
        return set.iterator().next();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("file://target/managed").routeId("foo").to("mock:result");
            }
        };
    }
}

