/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.RouteDefinition;

public class ManagedRouteLoadstatisticsTest
extends ManagementTestSupport {
    public void testLoadStatisticsAreDisabledByDefault() throws Exception {
        if (ManagedRouteLoadstatisticsTest.isPlatform("aix")) {
            return;
        }
        boolean load = this.context.getManagementStrategy().getManagementAgent().getLoadStatisticsEnabled() != null && this.context.getManagementStrategy().getManagementAgent().getLoadStatisticsEnabled() != false;
        ManagedRouteLoadstatisticsTest.assertFalse((boolean)load);
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ObjectName.getInstance("org.apache.camel:context=camel-1,type=routes,name=\"route1\"");
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.asyncSendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        String load01 = (String)mbeanServer.getAttribute(on, "Load01");
        String load05 = (String)mbeanServer.getAttribute(on, "Load05");
        String load15 = (String)mbeanServer.getAttribute(on, "Load15");
        ManagedRouteLoadstatisticsTest.assertEquals((String)"", (String)load01);
        ManagedRouteLoadstatisticsTest.assertEquals((String)"", (String)load05);
        ManagedRouteLoadstatisticsTest.assertEquals((String)"", (String)load15);
    }

    public void testEnableLoadStatistics() throws Exception {
        if (ManagedRouteLoadstatisticsTest.isPlatform("aix")) {
            return;
        }
        this.context.getManagementStrategy().getManagementAgent().setLoadStatisticsEnabled(Boolean.valueOf(true));
        this.context.stop();
        this.context.start();
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ObjectName.getInstance("org.apache.camel:context=camel-1,type=routes,name=\"route1\"");
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.asyncSendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        Thread.sleep(2000L);
        String load01 = (String)mbeanServer.getAttribute(on, "Load01");
        String load05 = (String)mbeanServer.getAttribute(on, "Load05");
        String load15 = (String)mbeanServer.getAttribute(on, "Load15");
        ManagedRouteLoadstatisticsTest.assertNotNull((Object)load01);
        ManagedRouteLoadstatisticsTest.assertNotNull((Object)load05);
        ManagedRouteLoadstatisticsTest.assertNotNull((Object)load15);
        ManagedRouteLoadstatisticsTest.assertTrue((Double.parseDouble(load01.replace(',', '.')) >= 0.0 ? 1 : 0) != 0);
        ManagedRouteLoadstatisticsTest.assertTrue((Double.parseDouble(load05.replace(',', '.')) >= 0.0 ? 1 : 0) != 0);
        ManagedRouteLoadstatisticsTest.assertTrue((Double.parseDouble(load15.replace(',', '.')) >= 0.0 ? 1 : 0) != 0);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").to("log:foo")).delay(2000L).to("mock:result");
            }
        };
    }
}

