/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.openmbean.TabularData;
import org.apache.camel.CamelContext;
import org.apache.camel.Route;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.rest.DummyRestConsumerFactory;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.SimpleRegistry;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.Registry;

public class ManagedRestRegistryTest
extends ManagementTestSupport {
    @Override
    protected CamelContext createCamelContext() throws Exception {
        SimpleRegistry registry = new SimpleRegistry();
        registry.put((Object)"dummy-test", (Object)new DummyRestConsumerFactory());
        return new DefaultCamelContext((Registry)registry);
    }

    public void testRestRegistry() throws Exception {
        if (ManagedRestRegistryTest.isPlatform("aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ObjectName.getInstance("org.apache.camel:context=camel-1,type=services,*");
        Set<ObjectName> names = mbeanServer.queryNames(on, null);
        ObjectName name = null;
        for (ObjectName service : names) {
            if (!service.toString().contains("DefaultRestRegistry")) continue;
            name = service;
            break;
        }
        ManagedRestRegistryTest.assertNotNull((String)"Cannot find DefaultRestRegistry", name);
        ManagedRestRegistryTest.assertTrue((boolean)mbeanServer.isRegistered(name));
        ManagedRestRegistryTest.assertEquals((Object)3, (Object)mbeanServer.getAttribute(name, "NumberOfRestServices"));
        TabularData data = (TabularData)mbeanServer.invoke(name, "listRestServices", null, null);
        ManagedRestRegistryTest.assertEquals((int)3, (int)data.size());
        String json = (String)mbeanServer.invoke(name, "apiDocAsJson", null, null);
        ManagedRestRegistryTest.assertNull((Object)json);
        for (Route route : this.context.getRoutes()) {
            this.context.stopRoute(route.getId());
            this.context.removeRoute(route.getId());
        }
        ManagedRestRegistryTest.assertEquals((Object)0, (Object)mbeanServer.getAttribute(name, "NumberOfRestServices"));
        data = (TabularData)mbeanServer.invoke(name, "listRestServices", null, null);
        ManagedRestRegistryTest.assertEquals((int)0, (int)data.size());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.restConfiguration().host("localhost");
                this.rest("/say/hello/{name}").get().to("direct:hello").description("Calling direct route");
                ((ProcessorDefinition)this.rest("/say/bye").description("the bye rest service").get().consumes("application/json").description("I am saying bye world").route().routeId("myRestRoute").transform().constant((Object)"Bye World")).endRest().post().to("mock:update");
                ((RouteDefinition)this.from("direct:hello").description("The hello route")).transform().simple("Hello ${header.name}");
            }
        };
    }
}

