/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.CamelContext;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.management.ManagementTestSupport;

public class ManagedCamelContextPropertiesTest
extends ManagementTestSupport {
    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        context.getManagementNameStrategy().setNamePattern("19-#name#");
        return context;
    }

    public void testGetSetProperties() throws Exception {
        if (ManagedCamelContextPropertiesTest.isPlatform("aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ObjectName.getInstance("org.apache.camel:context=19-camel-1,type=context,name=\"camel-1\"");
        ManagedCamelContextPropertiesTest.assertTrue((String)"Should be registered", (boolean)mbeanServer.isRegistered(on));
        String name = (String)mbeanServer.getAttribute(on, "CamelId");
        ManagedCamelContextPropertiesTest.assertEquals((String)"camel-1", (String)name);
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        mbeanServer.invoke(on, "setProperty", new String[]{"CamelLogDebugBodyMaxChars", "-1"}, new String[]{"java.lang.String", "java.lang.String"});
        mbeanServer.invoke(on, "setProperty", new String[]{"CamelLogDebugStreams", "true"}, new String[]{"java.lang.String", "java.lang.String"});
        Object invoke = mbeanServer.invoke(on, "getProperty", new String[]{"CamelLogDebugBodyMaxChars"}, new String[]{"java.lang.String"});
        ManagedCamelContextPropertiesTest.assertEquals((Object)"-1", (Object)invoke);
        invoke = mbeanServer.invoke(on, "getProperty", new String[]{"CamelLogDebugStreams"}, new String[]{"java.lang.String"});
        ManagedCamelContextPropertiesTest.assertEquals((Object)"true", (Object)invoke);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").to("mock:result");
            }
        };
    }
}

