/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.Set;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.apache.camel.CamelContext;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.management.JmxInstrumentationUsingPropertiesTest;

public class JmxInstrumentationDisableOnCamelContextTest
extends JmxInstrumentationUsingPropertiesTest {
    @Override
    protected boolean useJmx() {
        return false;
    }

    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext camel = super.createCamelContext();
        camel.disableJMX();
        return camel;
    }

    @Override
    public void testMBeansRegistered() throws Exception {
        if (JmxInstrumentationDisableOnCamelContextTest.isPlatform("aix")) {
            return;
        }
        this.resolveMandatoryEndpoint("mock:end", MockEndpoint.class);
        Set<ObjectName> s = this.mbsc.queryNames(new ObjectName(this.domainName + ":type=endpoints,*"), null);
        JmxInstrumentationDisableOnCamelContextTest.assertEquals((String)("Could not find 0 endpoints: " + s), (int)0, (int)s.size());
        s = this.mbsc.queryNames(new ObjectName(this.domainName + ":type=contexts,*"), null);
        JmxInstrumentationDisableOnCamelContextTest.assertEquals((String)("Could not find 0 context: " + s), (int)0, (int)s.size());
        s = this.mbsc.queryNames(new ObjectName(this.domainName + ":type=processors,*"), null);
        JmxInstrumentationDisableOnCamelContextTest.assertEquals((String)("Could not find 0 processor: " + s), (int)0, (int)s.size());
        s = this.mbsc.queryNames(new ObjectName(this.domainName + ":type=routes,*"), null);
        JmxInstrumentationDisableOnCamelContextTest.assertEquals((String)("Could not find 0 route: " + s), (int)0, (int)s.size());
    }

    @Override
    protected void verifyCounter(MBeanServerConnection beanServer, ObjectName name) throws Exception {
        Set<ObjectName> s = beanServer.queryNames(name, null);
        JmxInstrumentationDisableOnCamelContextTest.assertEquals((String)("Found mbeans: " + s), (int)0, (int)s.size());
    }
}

