/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Processor;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;

public class ExceptionWithManagementTest
extends ContextTestSupport {
    @Override
    protected boolean useJmx() {
        return true;
    }

    public void testExceptionHandler() throws Exception {
        MockEndpoint error = this.resolveMandatoryEndpoint("mock:error", MockEndpoint.class);
        error.expectedMessageCount(1);
        MockEndpoint out = this.resolveMandatoryEndpoint("mock:out", MockEndpoint.class);
        out.expectedMessageCount(0);
        this.template.send("direct:start", ExchangePattern.InOnly, new Processor(){

            public void process(Exchange exchange) throws Exception {
                exchange.getIn().setBody((Object)"hello");
            }
        });
        error.assertIsSatisfied();
        out.assertIsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.errorHandler((ErrorHandlerBuilder)this.deadLetterChannel("mock:error").redeliveryDelay(0L).maximumRedeliveries(3));
                this.onException(IllegalArgumentException.class).maximumRedeliveries(1).to("mock:error");
                ((RouteDefinition)this.from("direct:start").process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        throw new IllegalArgumentException("intentional error");
                    }
                })).to("mock:out");
            }
        };
    }
}

