/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.management.event.ExchangeCompletedEvent;
import org.apache.camel.management.event.ExchangeCreatedEvent;
import org.apache.camel.management.event.ExchangeFailureHandledEvent;
import org.apache.camel.management.event.ExchangeFailureHandlingEvent;
import org.apache.camel.management.event.ExchangeRedeliveryEvent;
import org.apache.camel.management.event.ExchangeSendingEvent;
import org.apache.camel.management.event.ExchangeSentEvent;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.spi.Registry;
import org.apache.camel.support.EventNotifierSupport;

public class EventNotifierRedeliveryEventsTest
extends ContextTestSupport {
    private static List<EventObject> events = new ArrayList<EventObject>();

    @Override
    public void setUp() throws Exception {
        events.clear();
        super.setUp();
    }

    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Override
    protected CamelContext createCamelContext() throws Exception {
        DefaultCamelContext context = new DefaultCamelContext((Registry)this.createRegistry());
        context.getManagementStrategy().addEventNotifier((EventNotifier)new EventNotifierSupport(){

            public void notify(EventObject event) throws Exception {
                events.add(event);
            }

            public boolean isEnabled(EventObject event) {
                return true;
            }

            protected void doStart() throws Exception {
                this.setIgnoreCamelContextEvents(true);
                this.setIgnoreRouteEvents(true);
                this.setIgnoreServiceEvents(true);
            }

            protected void doStop() throws Exception {
            }
        });
        return context;
    }

    public void testExchangeRedeliverySync() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.errorHandler((ErrorHandlerBuilder)this.deadLetterChannel("mock:dead").maximumRedeliveries(4).redeliveryDelay(0L));
                this.from("direct:start").throwException((Exception)new IllegalArgumentException("Damn"));
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:dead").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        EventNotifierRedeliveryEventsTest.assertTrue((boolean)this.oneExchangeDone.matchesMockWaitTime());
        EventNotifierRedeliveryEventsTest.assertEquals((int)12, (int)events.size());
        EventNotifierRedeliveryEventsTest.assertIsInstanceOf(ExchangeSendingEvent.class, events.get(0));
        EventNotifierRedeliveryEventsTest.assertIsInstanceOf(ExchangeCreatedEvent.class, events.get(1));
        ExchangeRedeliveryEvent e = EventNotifierRedeliveryEventsTest.assertIsInstanceOf(ExchangeRedeliveryEvent.class, events.get(2));
        EventNotifierRedeliveryEventsTest.assertEquals((int)1, (int)e.getAttempt());
        e = EventNotifierRedeliveryEventsTest.assertIsInstanceOf(ExchangeRedeliveryEvent.class, events.get(3));
        EventNotifierRedeliveryEventsTest.assertEquals((int)2, (int)e.getAttempt());
        e = EventNotifierRedeliveryEventsTest.assertIsInstanceOf(ExchangeRedeliveryEvent.class, events.get(4));
        EventNotifierRedeliveryEventsTest.assertEquals((int)3, (int)e.getAttempt());
        e = EventNotifierRedeliveryEventsTest.assertIsInstanceOf(ExchangeRedeliveryEvent.class, events.get(5));
        EventNotifierRedeliveryEventsTest.assertEquals((int)4, (int)e.getAttempt());
        EventNotifierRedeliveryEventsTest.assertIsInstanceOf(ExchangeFailureHandlingEvent.class, events.get(6));
        EventNotifierRedeliveryEventsTest.assertIsInstanceOf(ExchangeSendingEvent.class, events.get(7));
        EventNotifierRedeliveryEventsTest.assertIsInstanceOf(ExchangeSentEvent.class, events.get(8));
        EventNotifierRedeliveryEventsTest.assertIsInstanceOf(ExchangeFailureHandledEvent.class, events.get(9));
        EventNotifierRedeliveryEventsTest.assertIsInstanceOf(ExchangeCompletedEvent.class, events.get(10));
        EventNotifierRedeliveryEventsTest.assertIsInstanceOf(ExchangeSentEvent.class, events.get(11));
    }

    public void testExchangeRedeliveryAsync() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.errorHandler((ErrorHandlerBuilder)this.deadLetterChannel("mock:dead").maximumRedeliveries(4).asyncDelayedRedelivery().redeliveryDelay(10L));
                this.from("direct:start").throwException((Exception)new IllegalArgumentException("Damn"));
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:dead").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        EventNotifierRedeliveryEventsTest.assertTrue((boolean)this.oneExchangeDone.matchesMockWaitTime());
        EventNotifierRedeliveryEventsTest.assertEquals((int)12, (int)events.size());
        EventNotifierRedeliveryEventsTest.assertIsInstanceOf(ExchangeSendingEvent.class, events.get(0));
        EventNotifierRedeliveryEventsTest.assertIsInstanceOf(ExchangeCreatedEvent.class, events.get(1));
        ExchangeRedeliveryEvent e = EventNotifierRedeliveryEventsTest.assertIsInstanceOf(ExchangeRedeliveryEvent.class, events.get(2));
        EventNotifierRedeliveryEventsTest.assertEquals((int)1, (int)e.getAttempt());
        e = EventNotifierRedeliveryEventsTest.assertIsInstanceOf(ExchangeRedeliveryEvent.class, events.get(3));
        EventNotifierRedeliveryEventsTest.assertEquals((int)2, (int)e.getAttempt());
        e = EventNotifierRedeliveryEventsTest.assertIsInstanceOf(ExchangeRedeliveryEvent.class, events.get(4));
        EventNotifierRedeliveryEventsTest.assertEquals((int)3, (int)e.getAttempt());
        e = EventNotifierRedeliveryEventsTest.assertIsInstanceOf(ExchangeRedeliveryEvent.class, events.get(5));
        EventNotifierRedeliveryEventsTest.assertEquals((int)4, (int)e.getAttempt());
    }
}

