/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.List;
import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.RouteDefinition;

public class BacklogTracerPatternRouteTest
extends ManagementTestSupport {
    public void testBacklogTracerPattern() throws Exception {
        if (BacklogTracerPatternRouteTest.isPlatform("aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = new ObjectName("org.apache.camel:context=camel-1,type=tracer,name=BacklogTracer");
        BacklogTracerPatternRouteTest.assertNotNull((Object)on);
        mbeanServer.isRegistered(on);
        Boolean enabled = (Boolean)mbeanServer.getAttribute(on, "Enabled");
        BacklogTracerPatternRouteTest.assertEquals((String)"Should not be enabled", (Object)Boolean.FALSE, (Object)enabled);
        Integer size = (Integer)mbeanServer.getAttribute(on, "BacklogSize");
        BacklogTracerPatternRouteTest.assertEquals((String)"Should be 1000", (int)1000, (int)size);
        mbeanServer.setAttribute(on, new Attribute("TracePattern", "coolRoute"));
        mbeanServer.setAttribute(on, new Attribute("Enabled", Boolean.TRUE));
        this.getMockEndpoint("mock:foo").expectedMessageCount(2);
        this.getMockEndpoint("mock:bar").expectedMessageCount(2);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.template.sendBody("direct:start", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
        List events = (List)mbeanServer.invoke(on, "dumpTracedMessages", new Object[]{"foo"}, new String[]{"java.lang.String"});
        BacklogTracerPatternRouteTest.assertNotNull((Object)events);
        BacklogTracerPatternRouteTest.assertEquals((int)2, (int)events.size());
        events = (List)mbeanServer.invoke(on, "dumpTracedMessages", new Object[]{"bar"}, new String[]{"java.lang.String"});
        BacklogTracerPatternRouteTest.assertNotNull((Object)events);
        BacklogTracerPatternRouteTest.assertEquals((int)2, (int)events.size());
        events = (List)mbeanServer.invoke(on, "dumpTracedMessages", new Object[]{"beer"}, new String[]{"java.lang.String"});
        BacklogTracerPatternRouteTest.assertNotNull((Object)events);
        BacklogTracerPatternRouteTest.assertEquals((int)0, (int)events.size());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                BacklogTracerPatternRouteTest.this.context.setUseBreadcrumb(Boolean.valueOf(false));
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:start").routeId("coolRoute").to("direct:beer")).to("mock:foo")).id("foo")).to("mock:bar")).id("bar");
                ((RouteDefinition)this.from("direct:beer").routeId("beerRoute").to("mock:beer")).id("beer");
            }
        };
    }
}

