/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.tokenizer;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.xml.Namespaces;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.SplitDefinition;

public class XMLTokenizeLanguageStreamingFileTest
extends ContextTestSupport {
    @Override
    protected void setUp() throws Exception {
        XMLTokenizeLanguageStreamingFileTest.deleteDirectory("target/xmltokenize");
        super.setUp();
    }

    public void testFromFile() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"<c:child some_attr='a' anotherAttr='a' xmlns:c=\"urn:c\"></c:child>", "<c:child some_attr='b' anotherAttr='b' xmlns:c=\"urn:c\"></c:child>", "<c:child some_attr='c' anotherAttr='c' xmlns:c=\"urn:c\"></c:child>", "<c:child some_attr='d' anotherAttr='d' xmlns:c=\"urn:c\"></c:child>"});
        String body = "<?xml version='1.0' encoding='UTF-8'?><c:parent xmlns:c='urn:c'><c:child some_attr='a' anotherAttr='a'></c:child><c:child some_attr='b' anotherAttr='b'></c:child><c:child some_attr='c' anotherAttr='c'></c:child><c:child some_attr='d' anotherAttr='d'></c:child></c:parent>";
        XMLTokenizeLanguageStreamingFileTest.deleteDirectory("target/xmltokenize");
        this.template.sendBodyAndHeader("file:target/xmltokenize", (Object)body, "CamelFileName", (Object)"myxml.xml");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){
            Namespaces ns = new Namespaces("C", "urn:c");

            public void configure() {
                ((ExpressionNode)((SplitDefinition)this.from("file:target/xmltokenize").split().xtokenize("//C:child", this.ns)).streaming().to("mock:result")).end();
            }
        };
    }
}

