/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.ValueBuilder;
import org.apache.camel.builder.xml.Namespaces;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.SplitDefinition;

public class XMLTokenSplitTest
extends ContextTestSupport {
    @Override
    protected void setUp() throws Exception {
        XMLTokenSplitTest.deleteDirectory("target/xtokenizer");
        XMLTokenSplitTest.deleteDirectory("target/xtokenizer2");
        super.setUp();
    }

    public void testXMLToken() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:split");
        mock.expectedMessageCount(3);
        ((ValueBuilder)mock.message(0).body()).isEqualTo((Object)"<order id=\"1\" xmlns=\"http:acme.com\">Camel in Action</order>");
        ((ValueBuilder)mock.message(1).body()).isEqualTo((Object)"<order id=\"2\" xmlns=\"http:acme.com\">ActiveMQ in Action</order>");
        ((ValueBuilder)mock.message(2).body()).isEqualTo((Object)"<order id=\"3\" xmlns=\"http:acme.com\">DSL in Action</order>");
        String body = this.createBody();
        this.template.sendBodyAndHeader("file:target/xtokenizer", (Object)body, "CamelFileName", (Object)"orders.xml");
        this.assertMockEndpointsSatisfied();
    }

    public void testXMLToken2() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:split");
        mock.expectedMessageCount(3);
        ((ValueBuilder)mock.message(0).body()).isEqualTo((Object)"<order id=\"1\" xmlns=\"http:acme.com\">Camel in Action</order>");
        ((ValueBuilder)mock.message(1).body()).isEqualTo((Object)"<order id=\"2\" xmlns=\"http:acme.com\">ActiveMQ in Action</order>");
        ((ValueBuilder)mock.message(2).body()).isEqualTo((Object)"<order id=\"3\" xmlns=\"http:acme.com\">DSL in Action</order>");
        String body = this.createBody();
        this.template.sendBodyAndHeader("file:target/xtokenizer2", (Object)body, "CamelFileName", (Object)"orders.xml");
        this.assertMockEndpointsSatisfied();
    }

    protected String createBody() {
        StringBuilder sb = new StringBuilder("<?xml version=\"1.0\"?>\n");
        sb.append("<orders xmlns=\"http:acme.com\">\n");
        sb.append("  <order id=\"1\">Camel in Action</order>\n");
        sb.append("  <order id=\"2\">ActiveMQ in Action</order>\n");
        sb.append("  <order id=\"3\">DSL in Action</order>\n");
        sb.append("  <order id=\"4\" xmlns=\"\">Illegal Action</order>\n");
        sb.append("</orders>");
        return sb.toString();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){
            Namespaces ns = new Namespaces("", "http:acme.com");

            public void configure() throws Exception {
                ((SplitDefinition)this.from("file:target/xtokenizer").split().xtokenize("//orders/order", this.ns)).to("mock:split");
                this.from("file:target/xtokenizer2").split((Expression)this.body().xtokenize("//orders/order", this.ns)).to("mock:split");
            }
        };
    }
}

