/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language;

import java.io.File;
import java.util.Calendar;
import org.apache.camel.Exchange;
import org.apache.camel.LanguageTestSupport;
import org.apache.camel.component.file.FileConsumer;
import org.apache.camel.component.file.FileEndpoint;
import org.apache.camel.component.file.GenericFile;

public class FileLanguageExtSingleTest
extends LanguageTestSupport {
    private File file;

    @Override
    protected String getLanguageName() {
        return "file";
    }

    public void testFileNoSingleExt() throws Exception {
        this.assertExpression("${file:name}", "test" + File.separator + "bye.def.txt");
        this.assertExpression("${file:name.noext}", "test" + File.separator + "bye");
        this.assertExpression("${file:name.noext.single}", "test" + File.separator + "bye.def");
        this.assertExpression("${file:name.ext}", "def.txt");
        this.assertExpression("${file:name.ext.single}", "txt");
        this.assertExpression("${file:onlyname.noext}", "bye");
        this.assertExpression("${file:onlyname.noext.single}", "bye.def");
    }

    @Override
    public Exchange createExchange() {
        String uri = "file://target/filelanguage?fileExist=Override";
        this.template.sendBodyAndHeader(uri, (Object)"Bye World", "CamelFileName", (Object)"test/bye.def.txt");
        this.file = new File("target/filelanguage/test/bye.def.txt");
        GenericFile gf = FileConsumer.asGenericFile((String)"target/filelanguage", (File)this.file, null);
        FileEndpoint endpoint = this.getMandatoryEndpoint(uri, FileEndpoint.class);
        Exchange answer = endpoint.createExchange(gf);
        endpoint.configureMessage(gf, answer.getIn());
        Calendar cal = Calendar.getInstance();
        cal.set(1974, 3, 20);
        answer.getIn().setHeader("birthday", (Object)cal.getTime());
        cal.set(2008, 7, 8);
        answer.getOut().setHeader("special", (Object)cal.getTime());
        return answer;
    }
}

