/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.aggregate.AggregationStrategy;
import org.apache.camel.processor.aggregate.UseLatestAggregationStrategy;

public class SplitterParallelIssueTest
extends ContextTestSupport {
    private int size = 20;
    private int delay = 100;

    public void testSplitParallel() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:end");
        mock.expectedMessageCount(this.size);
        int time = Math.max(10000, this.size * 2 * this.delay);
        mock.setResultWaitTime((long)time);
        int i = 0;
        while (i < this.size) {
            final int num = i++;
            new Thread(new Runnable(){

                @Override
                public void run() {
                    SplitterParallelIssueTest.this.template.sendBody("direct:start", (Object)("" + num));
                }
            }).start();
        }
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((ExpressionNode)((RouteDefinition)this.from("direct:start").log("Start ${body}")).split((Expression)this.body().tokenize("@"), (AggregationStrategy)new UseLatestAggregationStrategy()).parallelProcessing().streaming().process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        int num = (Integer)exchange.getIn().getBody(Integer.TYPE);
                        long sleep = num * SplitterParallelIssueTest.this.delay;
                        log.info("Sleep for " + sleep + "ms");
                        Thread.sleep(sleep);
                    }
                })).end().log("End ${body}").to("mock:end");
            }
        };
    }
}

