/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.OnExceptionDefinition;

public class RedeliveryPolicyOnExceptionWhileRedeliveringIssueTest
extends ContextTestSupport {
    public void testMessageShouldGoToError() throws Exception {
        String msg = "payload";
        this.getMockEndpoint("mock:destination").expectedMessageCount(0);
        this.getMockEndpoint("mock:error").expectedMessageCount(1);
        this.getMockEndpoint("mock:error").expectedBodiesReceived(new Object[]{msg});
        this.template.sendBody("direct:source", (Object)msg);
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((OnExceptionDefinition)this.from("direct:source").onException(FirstException.class).maximumRedeliveries(-1).handled(true).end().onException(SecondException.class).handled(true).to("mock:error")).end().process((Processor)new ExceptionThrowingProcessor()).to("mock:destination");
            }
        };
    }

    private class ExceptionThrowingProcessor
    implements Processor {
        private ExceptionThrowingProcessor() {
        }

        public void process(Exchange exchange) throws Exception {
            String camelRedeliveryCounter = (String)exchange.getIn().getHeader("CamelRedeliveryCounter", String.class);
            int redeliveries = camelRedeliveryCounter == null ? 0 : Integer.valueOf(camelRedeliveryCounter);
            switch (redeliveries) {
                case 0: {
                    throw new FirstException();
                }
                case 1: {
                    throw new SecondException();
                }
            }
        }
    }

    private class SecondException
    extends Exception {
        private static final long serialVersionUID = 1L;

        private SecondException() {
        }
    }

    private class FirstException
    extends Exception {
        private static final long serialVersionUID = 1L;

        private FirstException() {
        }
    }
}

