/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import org.apache.camel.ConsumerTemplate;
import org.apache.camel.Exchange;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.model.RouteDefinition;
import org.junit.Assert;
import org.junit.Test;

public class RedeliveryErrorHandlerAsyncDelayedTwoCamelContextIssueTest {
    @Test
    public void shouldNotBreakRedeliveriesOfSecondContextAfterFirstBeingStopped() throws Exception {
        DefaultCamelContext context1 = this.createContext();
        ProducerTemplate producer1 = context1.createProducerTemplate();
        ConsumerTemplate consumer1 = context1.createConsumerTemplate();
        context1.start();
        producer1.sendBody("seda://input", (Object)"Hey1");
        Exchange ex1 = consumer1.receive("seda://output", 5000L);
        DefaultCamelContext context2 = this.createContext();
        ProducerTemplate producer2 = context2.createProducerTemplate();
        ConsumerTemplate consumer2 = context2.createConsumerTemplate();
        context2.start();
        consumer1.stop();
        producer1.stop();
        context1.stop();
        producer2.sendBody("seda://input", (Object)"Hey2");
        Exchange ex2 = consumer2.receive("seda://output", 5000L);
        Assert.assertNotNull((Object)ex1);
        Assert.assertEquals((Object)"Hey1", (Object)ex1.getIn().getBody());
        Assert.assertNotNull((Object)ex2);
        Assert.assertEquals((Object)"Hey2", (Object)ex2.getIn().getBody());
        consumer2.stop();
        producer2.stop();
        context2.stop();
    }

    private DefaultCamelContext createContext() throws Exception {
        DefaultCamelContext context = new DefaultCamelContext();
        context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.onException(Exception.class).redeliveryDelay(100L).maximumRedeliveries(5).maximumRedeliveryDelay(1000L).backOffMultiplier(1.0).asyncDelayedRedelivery();
                ((RouteDefinition)this.from("seda://input").bean(ProblematicBean.class)).to("seda://output");
            }
        });
        return context;
    }

    public static final class ProblematicBean {
        int counter;

        public void doSomething() {
            if (this.counter++ < 2) {
                throw new RuntimeException();
            }
        }
    }
}

