/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.bean.ProxyHelper;

public class ProxyReturnNullIssueTest
extends ContextTestSupport {
    public void testEcho() throws Exception {
        Echo service = (Echo)ProxyHelper.createProxy((Endpoint)this.context.getEndpoint("direct:echo"), Echo.class);
        ProxyReturnNullIssueTest.assertEquals((String)"Hello World", (String)service.echo("Hello World"));
    }

    public void testEchoNull() throws Exception {
        Echo service = (Echo)ProxyHelper.createProxy((Endpoint)this.context.getEndpoint("direct:echo"), Echo.class);
        ProxyReturnNullIssueTest.assertEquals(null, (String)service.echo(null));
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:echo").bean((Object)new MyEchoBean());
            }
        };
    }

    public static class MyEchoBean
    implements Echo {
        @Override
        public String echo(String text) {
            return text;
        }
    }

    public static interface Echo {
        public String echo(String var1);
    }
}

