/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;

public class OnExceptionBeforeErrorHandlerIssueTest
extends ContextTestSupport {
    public void testOk() throws Exception {
        this.context.startRoute("foo");
        this.getMockEndpoint("mock:error").expectedMessageCount(0);
        this.getMockEndpoint("mock:dead").expectedMessageCount(0);
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    public void testKabom() throws Exception {
        this.context.startRoute("foo");
        this.getMockEndpoint("mock:error").expectedMessageCount(0);
        this.getMockEndpoint("mock:dead").expectedMessageCount(1);
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        this.template.sendBody("direct:start", (Object)"kabom");
        this.assertMockEndpointsSatisfied();
    }

    public void testIllegal() throws Exception {
        this.context.startRoute("foo");
        this.getMockEndpoint("mock:error").expectedMessageCount(1);
        this.getMockEndpoint("mock:dead").expectedMessageCount(0);
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        this.template.sendBody("direct:start", (Object)"illegal");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((OnExceptionDefinition)((ProcessorDefinition)this.onException(IllegalArgumentException.class).handled(true).setBody().constant((Object)"Handled")).to("mock:error")).end();
                this.errorHandler((ErrorHandlerBuilder)this.deadLetterChannel("mock:dead").useOriginalMessage());
                ((RouteDefinition)this.from("direct:start").routeId("foo").noAutoStartup().process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        String body = (String)exchange.getIn().getBody(String.class);
                        if ("illegal".equals(body)) {
                            throw new IllegalArgumentException("I cannot do this");
                        }
                        if ("kabom".equals(body)) {
                            throw new RuntimeException("Kabom");
                        }
                    }
                })).to("mock:result");
            }
        };
    }
}

